/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import org.rapidoid.RapidoidThing;
import org.rapidoid.gui.reqinfo.IReqInfo;
import org.rapidoid.gui.reqinfo.ReqInfo;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.render.Getter;
import org.rapidoid.util.Msc;

public class HtmlPageUtils
extends RapidoidThing {
    static final Getter HAS_PAGE = new Getter(){

        public Object get(String page) {
            return ReqInfo.get().hasRoute(HttpVerb.GET, HtmlPageUtils.strToUri(page));
        }
    };
    static final Getter HAS_SPECIAL_PAGE = new Getter(){

        public Object get(String page) {
            return ReqInfo.get().hasRoute(HttpVerb.GET, Msc.specialUri((String[])new String[]{page}));
        }
    };
    static final Getter HAS_ROLE = new Getter(){

        public Object get(String role) {
            return HtmlPageUtils.hasRole(role);
        }
    };
    static final Getter HAS_PATH = new Getter(){

        public Object get(String path) {
            return HtmlPageUtils.hasPath(path);
        }
    };
    static final Getter HAS_ZONE = new Getter(){

        public Object get(String zone) {
            return HtmlPageUtils.hasZone(zone);
        }
    };

    static boolean hasRole(String role) {
        IReqInfo req = ReqInfo.get();
        return req.roles().contains(role);
    }

    static boolean hasPath(String path) {
        IReqInfo req = ReqInfo.get();
        return HtmlPageUtils.uriToStr(req.path()).equals(path);
    }

    static boolean hasZone(String zone) {
        IReqInfo req = ReqInfo.get();
        return req.zone().equals(zone);
    }

    private static String uriToStr(String path) {
        return path.replace('/', '$');
    }

    private static String strToUri(String path) {
        return path.replace('$', '/');
    }
}

