/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui.menu;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.data.YAML;
import org.rapidoid.gui.menu.PageMenuItem;
import org.rapidoid.gui.menu.PageSubMenuItem;
import org.rapidoid.io.Res;
import org.rapidoid.render.Templates;
import org.rapidoid.u.U;

public class PageMenu
extends RapidoidThing {
    private final List<PageMenuItem> items;
    private volatile String uri;

    public PageMenu(List<PageMenuItem> items) {
        this.items = items;
    }

    public List<PageMenuItem> items() {
        return this.items;
    }

    public String uri() {
        return this.uri;
    }

    public PageMenu uri(String uri) {
        this.uri = uri;
        for (PageMenuItem item : this.items) {
            item.setActiveUri(uri);
        }
        return this;
    }

    public String toString() {
        return U.join((String)"\n", this.items);
    }

    public static PageMenu parse(String filename) {
        byte[] yaml = Res.from((String)filename, (String[])new String[0]).getBytesOrNull();
        Map data = yaml != null ? (Map)YAML.parse((byte[])yaml, Map.class) : null;
        return PageMenu.from(data);
    }

    public static PageMenu from(Map<String, ?> data) {
        return (PageMenu)((Object)Cls.struct(PageMenu.class, PageMenuItem.class, (Object)U.or(data, (Object)U.map())));
    }

    public List<PageMenuItem> leftItems() {
        List left = U.list();
        for (PageMenuItem item : this.items) {
            if (item.isRight()) continue;
            left.add(item);
        }
        return left;
    }

    public List<PageMenuItem> rightItems() {
        List right = U.list();
        for (PageMenuItem item : this.items) {
            if (!item.isRight()) continue;
            right.add(item);
        }
        return right;
    }

    public List<PageMenuItem> rightItemsReversed() {
        List<PageMenuItem> list = this.rightItems();
        Collections.reverse(list);
        return list;
    }

    public void renderContentTemplates(Map<String, Object> model) {
        for (PageMenuItem item : this.items) {
            if (item.getCaption().contains("{")) {
                item.setCaption(Templates.compile((String)item.getCaption()).render(model));
            }
            if (item.getSubmenu() == null) continue;
            for (PageSubMenuItem subItem : item.getSubmenu().getItems()) {
                subItem.setCaption(Templates.compile((String)subItem.getCaption()).render(model));
            }
        }
    }
}

