/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.BeanProperties;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.beany.PropertySelector;
import org.rapidoid.cls.Cls;
import org.rapidoid.lambda.Calc;
import org.rapidoid.model.Item;
import org.rapidoid.model.Items;
import org.rapidoid.model.ModelPropertySelector;
import org.rapidoid.model.Property;
import org.rapidoid.model.impl.BeanItem;
import org.rapidoid.model.impl.BeanListItems;
import org.rapidoid.model.impl.BeanProperty;
import org.rapidoid.model.impl.BuiltInProperty;
import org.rapidoid.model.impl.CalcProperty;
import org.rapidoid.model.impl.ItemPropertyVar;
import org.rapidoid.model.impl.MapItem;
import org.rapidoid.u.U;
import org.rapidoid.var.Var;

public class Models
extends RapidoidThing {
    private static final Set<String> SPECIAL_PROPERTIES = U.set((Object[])new String[]{"id", "version", "createdby", "createdon", "lastupdatedby", "lastupdatedon"});

    public static <T> Items beanItems(Class<T> beanType, Object ... beans) {
        BeanListItems<T> items = new BeanListItems<T>(beanType);
        for (Object bean : beans) {
            items.add(Models.item(bean));
        }
        return items;
    }

    public static <T> Items beanItemsInfer(T ... items) {
        U.must((items.length > 0 ? 1 : 0) != 0, (String)"Must have at least 1 item to infer the bean type!");
        Class<?> type = items[0].getClass();
        return Models.beanItems(type, items);
    }

    public static Item item(Object value) {
        return value instanceof Map ? new MapItem((Map)value) : new BeanItem(value);
    }

    public static Property propertyOf(Class<?> beanType, String property) {
        if (property.startsWith("_")) {
            return new BuiltInProperty(property);
        }
        BeanProperties props = Beany.propertiesOf(beanType);
        if (beanType == Object.class) {
            return new BeanProperty(property, property.equals("id") ? Long.TYPE : String.class, null, null);
        }
        Prop prop = props.get(property);
        U.must((prop != null ? 1 : 0) != 0, (String)"Cannot find property %s in class %s!", (Object)property, beanType);
        return Models.prop(prop);
    }

    public static List<Property> propertiesOf(Object target, String ... propertyNames) {
        return Models.properties(Beany.propertiesOf((Object)target).select((PropertySelector)new ModelPropertySelector(propertyNames){

            public boolean eval(Prop prop) throws Exception {
                return Models.isReadable(prop);
            }
        }));
    }

    public static List<Property> editablePropertiesOf(Object target, String ... propertyNames) {
        return Models.properties(Beany.propertiesOf((Object)target).select((PropertySelector)new ModelPropertySelector(propertyNames){

            public boolean eval(Prop prop) throws Exception {
                return Models.isEditable(prop);
            }
        }));
    }

    public static List<Property> readablePropertiesOf(Object target, String ... propertyNames) {
        return Models.properties(Beany.propertiesOf((Object)target).select((PropertySelector)new ModelPropertySelector(propertyNames){

            public boolean eval(Prop prop) throws Exception {
                return Models.isReadable(prop);
            }
        }));
    }

    private static List<Property> properties(BeanProperties props) {
        String key = Property.class.getCanonicalName();
        List properties = (List)props.extras.get(key);
        if (properties == null) {
            properties = U.list();
            for (Prop prop : props) {
                properties.add(Models.prop(prop));
            }
            props.extras.put(key, properties);
        }
        return properties;
    }

    private static BeanProperty prop(Prop prop) {
        return new BeanProperty(prop.getName(), prop.getType(), prop.getGenericType(), prop.getAnnotations());
    }

    public static boolean isEditable(Prop prop) {
        String name = prop.getName();
        if (Models.isSpecialProperty(name)) {
            return false;
        }
        return !prop.isReadOnly() || Collection.class.isAssignableFrom(prop.getType());
    }

    public static boolean isReadable(Prop prop) {
        return true;
    }

    public static <T> Items mockBeanItems(int size, Class<T> beanType) {
        Object[] beans = new Object[size];
        for (int i = 0; i < beans.length; ++i) {
            beans[i] = Cls.newInstance(beanType);
            Beany.setId((Object)beans[i], (long)i);
        }
        return Models.beanItems(beanType, beans);
    }

    public static <T> Property property(String name, Calc<T> calc) {
        return new CalcProperty(name, calc);
    }

    public static <T> Var<T> propertyVar(String name, Item item, String property, T initValue, boolean readOnly) {
        return new ItemPropertyVar<T>(name, item, property, initValue, readOnly);
    }

    public static boolean isSpecialProperty(String name) {
        return SPECIAL_PROPERTIES.contains(name.toLowerCase());
    }
}

