/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.model.impl;

import java.util.Collections;
import java.util.List;
import org.rapidoid.cls.Cls;
import org.rapidoid.model.Item;
import org.rapidoid.model.Models;
import org.rapidoid.model.Property;
import org.rapidoid.model.impl.ListItems;
import org.rapidoid.u.U;

public class BeanListItems<T>
extends ListItems {
    private static final long serialVersionUID = 7346765152583871241L;
    protected final Class<T> beanType;

    public BeanListItems(Class<T> beanType) {
        this.beanType = beanType;
    }

    @Override
    public List<Property> properties(String ... properties) {
        return U.isEmpty((Object[])properties) ? this.inferProperties() : this.filterProperties(properties);
    }

    private List<Property> inferProperties() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Object item0 = this.get(0).value();
        return Models.propertiesOf(item0, new String[0]);
    }

    private List<Property> filterProperties(String[] properties) {
        if (this.isEmpty() || U.isEmpty((Object[])properties)) {
            return Collections.EMPTY_LIST;
        }
        Object item0 = this.get(0).value();
        return Models.propertiesOf(item0, properties);
    }

    @Override
    public boolean fitsIn(Item item) {
        return super.fitsIn(item) && (this.beanType == null || Cls.instanceOf((Object)item.value(), (Class[])new Class[]{this.beanType}));
    }

    @Override
    public Item ifFitsIn(Item item) {
        U.must((boolean)this.fitsIn(item), (String)"The item doesn't fit in the items, expected type '%s' but found: %s", this.beanType, (Object)Cls.of((Object)item.value()));
        return item;
    }
}

