/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.rapidoid.annotation.TransactionMode;
import org.rapidoid.ctx.With;
import org.rapidoid.http.FastHttp;
import org.rapidoid.http.HttpRoutes;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpWrapper;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.handler.AbstractHttpHandler;
import org.rapidoid.http.handler.HandlerInvocation;
import org.rapidoid.http.handler.HandlerResultProcessor;
import org.rapidoid.http.impl.MaybeReq;
import org.rapidoid.http.impl.ReqImpl;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.jpa.JPA;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.security.Secure;
import org.rapidoid.u.U;
import org.rapidoid.util.TokenAuthData;

public abstract class AbstractDecoratingHttpHandler
extends AbstractHttpHandler {
    private static final String CTX_TAG_INIT = "init";
    private static final String CTX_TAG_HANDLER = "handler";
    private static final String CTX_TAG_ERROR = "error";
    private static final HttpWrapper[] NO_WRAPPERS = new HttpWrapper[0];
    private final FastHttp http;

    public AbstractDecoratingHttpHandler(FastHttp http, HttpRoutes routes, RouteOptions options) {
        super(options);
        this.http = http;
    }

    @Override
    public boolean needsParams() {
        return true;
    }

    @Override
    public final HttpStatus handle(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        return this.options.managed() ? this.handleDecorating(ctx, isKeepAlive, req, extra) : this.handleNonDecorating(ctx, isKeepAlive, req, extra);
    }

    private HttpStatus handleNonDecorating(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        MaybeReq maybeReq = HttpUtils.maybe(req);
        ReqImpl reqq = (ReqImpl)req;
        Object result = this.handleReqAndPostProcess(ctx, isKeepAlive, req, extra);
        int code = -1;
        MediaType ctype = this.contentType;
        if (req != null && reqq.hasResponseAttached()) {
            Resp resp = req.response();
            ctype = resp.contentType();
            code = resp.code();
        }
        if (result == HttpStatus.NOT_FOUND) {
            this.http.notFound(ctx, isKeepAlive, ctype, this, req);
            return HttpStatus.NOT_FOUND;
        }
        if (result == HttpStatus.ASYNC) {
            return HttpStatus.ASYNC;
        }
        if (result instanceof Throwable) {
            Throwable err = (Throwable)result;
            HttpIO.INSTANCE.writeHttpResp(maybeReq, ctx, isKeepAlive, 500, MediaType.PLAIN_TEXT_UTF_8, "Internal server error!".getBytes());
            Log.error((String)"Error occurred during unmanaged request processing", (String)"request", (Object)req, (String)CTX_TAG_ERROR, (Object)err);
            return HttpStatus.DONE;
        }
        int respCode = code > 0 ? code : 200;
        HttpIO.INSTANCE.writeHttpResp(maybeReq, ctx, isKeepAlive, respCode, ctype, result);
        return HttpStatus.DONE;
    }

    private HttpStatus handleDecorating(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        if (!ctx.isAsync()) {
            ctx.async();
        }
        this.execHandlerJob(ctx, isKeepAlive, this.options.contentType(), req, extra);
        return HttpStatus.ASYNC;
    }

    private Set<String> userRoles(Req req, String username) {
        if (username != null) {
            try {
                return Customization.of(req).rolesProvider().getRolesForUser(req, username);
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    private TransactionMode before(Req req, String username, Set<String> roles) {
        if (U.notEmpty(this.options.roles()) && !Secure.hasAnyRole((String)username, roles, this.options.roles())) {
            throw new SecurityException("The user doesn't have the required roles!");
        }
        req.response().view(this.options.view()).contentType(this.options.contentType()).mvc(this.options.mvc());
        TransactionMode txMode = (TransactionMode)U.or((Object)this.options.transaction(), (Object)TransactionMode.NONE);
        if (txMode == TransactionMode.AUTO) {
            txMode = HttpUtils.isGetReq(req) ? TransactionMode.READ_ONLY : TransactionMode.READ_WRITE;
        }
        return txMode;
    }

    private void execHandlerJob(final Channel channel, final boolean isKeepAlive, final MediaType contentType, final Req req, final Object extra) {
        With.tag((String)CTX_TAG_INIT).exchange((Object)req).run(new Runnable(){
            volatile String username = null;
            volatile Set<String> roles = null;
            volatile Set<String> scope = null;

            @Override
            public void run() {
                try {
                    TokenAuthData auth = HttpUtils.getAuth(req);
                    if (auth != null) {
                        this.username = auth.user;
                    }
                    if (U.isEmpty((String)this.username)) {
                        HttpUtils.clearUserData(req);
                    }
                    this.roles = AbstractDecoratingHttpHandler.this.userRoles(req, this.username);
                    this.scope = auth != null ? auth.scope : null;
                    TransactionMode txMode = AbstractDecoratingHttpHandler.this.before(req, this.username, this.roles);
                    U.notNull((Object)txMode, (String)"txMode", (Object[])new Object[0]);
                    HttpWrapper[] wrappers = AbstractDecoratingHttpHandler.this.httpWrappers != null ? AbstractDecoratingHttpHandler.this.httpWrappers : (HttpWrapper[])U.or((Object)Customization.of(req).wrappers(), (Object)NO_WRAPPERS);
                    Runnable handleRequest = AbstractDecoratingHttpHandler.this.handlerWithWrappers(channel, isKeepAlive, contentType, req, extra, wrappers, txMode);
                    With.tag((String)AbstractDecoratingHttpHandler.CTX_TAG_HANDLER).exchange((Object)req).username(this.username).roles(this.roles).scope(this.scope).run(handleRequest);
                }
                catch (Throwable e) {
                    AbstractDecoratingHttpHandler.this.execErrorHandler(req, this.username, this.roles, this.scope, e);
                }
            }
        });
    }

    private HttpStatus execErrorHandler(final Req req, String username, Set<String> roles, Set<String> scope, final Throwable error) {
        With.tag((String)CTX_TAG_ERROR).exchange((Object)req).username(username).roles(roles).scope(scope).run(new Runnable(){

            @Override
            public void run() {
                AbstractDecoratingHttpHandler.this.handleError(req, error);
            }
        });
        return HttpStatus.ASYNC;
    }

    private Runnable handlerWithWrappers(final Channel channel, final boolean isKeepAlive, final MediaType contentType, final Req req, final Object extra, final HttpWrapper[] wrappers, final TransactionMode txMode) {
        return new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = !U.isEmpty((Object[])wrappers) ? AbstractDecoratingHttpHandler.this.wrap(channel, isKeepAlive, req, 0, extra, wrappers, txMode) : AbstractDecoratingHttpHandler.this.handleReqMaybeInTx(channel, isKeepAlive, req, extra, txMode);
                }
                catch (Throwable e) {
                    result = e;
                }
                AbstractDecoratingHttpHandler.this.complete(channel, isKeepAlive, contentType, req, result);
            }
        };
    }

    private Object handleReqMaybeInTx(final Channel channel, final boolean isKeepAlive, final Req req, final Object extra, TransactionMode txMode) throws Throwable {
        if (txMode != null && txMode != TransactionMode.NONE) {
            final AtomicReference<Throwable> result = new AtomicReference<Throwable>();
            try {
                JPA.transaction((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Object res = AbstractDecoratingHttpHandler.this.handleReqAndPostProcess(channel, isKeepAlive, req, extra);
                        if (res instanceof Throwable) {
                            Throwable err = (Throwable)res;
                            throw U.rte((String)"Error occurred inside the transactional web handler!", (Throwable)err);
                        }
                        result.set(res);
                    }
                }, (txMode == TransactionMode.READ_ONLY ? 1 : 0) != 0);
            }
            catch (Throwable e) {
                result.set(e);
            }
            return result.get();
        }
        return this.handleReqAndPostProcess(channel, isKeepAlive, req, extra);
    }

    private Runnable txWrap(final TransactionMode txMode, final Runnable handleRequest) {
        if (txMode != null && txMode != TransactionMode.NONE) {
            return new Runnable(){

                @Override
                public void run() {
                    JPA.transaction((Runnable)handleRequest, (txMode == TransactionMode.READ_ONLY ? 1 : 0) != 0);
                }
            };
        }
        return handleRequest;
    }

    private Object wrap(final Channel channel, final boolean isKeepAlive, final Req req, final int index, final Object extra, final HttpWrapper[] wrappers, final TransactionMode txMode) throws Exception {
        HttpWrapper wrapper = wrappers[index];
        HandlerInvocation invocation = new HandlerInvocation(){

            @Override
            public Object invoke() throws Exception {
                return this.invokeAndTransformResult(null);
            }

            @Override
            public Object invokeAndTransformResult(Mapper<Object, Object> transformation) throws Exception {
                try {
                    int next = index + 1;
                    Object val = next < wrappers.length ? AbstractDecoratingHttpHandler.this.wrap(channel, isKeepAlive, req, next, extra, wrappers, txMode) : AbstractDecoratingHttpHandler.this.handleReqMaybeInTx(channel, isKeepAlive, req, extra, txMode);
                    return transformation != null ? transformation.map(val) : val;
                }
                catch (Throwable e) {
                    return e;
                }
            }
        };
        return wrapper.wrap(req, invocation);
    }

    private Object handleError(Req req, Throwable e) {
        req.revert();
        req.async();
        HttpIO.INSTANCE.error(req, e, LogLevel.ERROR);
        req.done();
        return req;
    }

    protected abstract Object handleReq(Channel var1, boolean var2, Req var3, Object var4) throws Throwable;

    private Object handleReqAndPostProcess(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        Object result;
        try {
            result = this.handleReq(ctx, isKeepAlive, req, extra);
        }
        catch (Throwable e) {
            result = e;
        }
        return HandlerResultProcessor.INSTANCE.postProcessResult(req, result);
    }

    public void complete(Channel ctx, boolean isKeepAlive, MediaType contentType, Req req, Object result) {
        U.must((result != null ? 1 : 0) != 0, (String)"The post-processed result cannot be null!");
        U.must((!(result instanceof Req) ? 1 : 0) != 0, (String)"The post-processed result cannot be a Req instance!");
        U.must((!(result instanceof Resp) ? 1 : 0) != 0, (String)"The post-processed result cannot be a Resp instance!");
        if (result instanceof Throwable) {
            this.handleError(req, (Throwable)result);
            return;
        }
        if (result == HttpStatus.NOT_FOUND) {
            this.http.notFound(ctx, isKeepAlive, contentType, this, req);
            return;
        }
        if (result == HttpStatus.ERROR) {
            this.complete(ctx, isKeepAlive, contentType, req, U.rte((String)"Handler error!"));
            return;
        }
        if (result == HttpStatus.ASYNC) {
            return;
        }
        this.processNormalResult(req, result);
    }

    private void processNormalResult(Req req, Object result) {
        HttpUtils.resultToResponse(req, result);
        if (!req.isAsync()) {
            req.done();
        }
    }
}

