/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.cls.Cls;
import org.rapidoid.collection.Coll;
import org.rapidoid.config.BasicConfig;
import org.rapidoid.config.Conf;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.UserInfo;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.LoginProvider;
import org.rapidoid.http.customize.RolesProvider;
import org.rapidoid.http.impl.ChunkedResponse;
import org.rapidoid.http.impl.GUIUtil;
import org.rapidoid.http.impl.ReqImpl;
import org.rapidoid.http.impl.ResponseRenderer;
import org.rapidoid.io.IO;
import org.rapidoid.net.AsyncLogic;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;
import org.rapidoid.web.Screen;
import org.rapidoid.web.ScreenBean;

public class RespImpl
extends RapidoidThing
implements Resp {
    private final ReqImpl req;
    private volatile Object result = null;
    private volatile Object body = null;
    private volatile Object raw = null;
    private volatile int code = 200;
    private volatile MediaType contentType = HttpUtils.getDefaultContentType();
    private final Map<String, String> headers = Coll.synchronizedMap();
    private final Map<String, String> cookies = Coll.synchronizedMap();
    private final Map<String, Object> model = Coll.synchronizedMap();
    private volatile String redirect = null;
    private volatile String filename = null;
    private volatile File file = null;
    private volatile String view = null;
    private volatile boolean mvc = false;
    private volatile Screen screen;
    private volatile ChunkedResponse chunked;

    public RespImpl(ReqImpl req) {
        this.req = req;
    }

    @Override
    public synchronized Resp result(Object content) {
        this.ensureCanChange();
        this.result = content;
        return this;
    }

    @Override
    public synchronized Object result() {
        return this.result;
    }

    @Override
    public synchronized Resp body(byte[] body) {
        this.ensureCanChange();
        this.body = body;
        return this;
    }

    @Override
    public synchronized Resp body(ByteBuffer body) {
        this.ensureCanChange();
        this.body = body;
        return this;
    }

    @Override
    public synchronized Object body() {
        return this.body;
    }

    @Override
    public synchronized Resp raw(byte[] raw) {
        this.ensureCanChange();
        this.raw = raw;
        return this;
    }

    @Override
    public synchronized Resp raw(ByteBuffer raw) {
        this.ensureCanChange();
        this.raw = raw;
        return this;
    }

    @Override
    public synchronized Object raw() {
        return this.raw;
    }

    @Override
    public synchronized Resp code(int code) {
        this.ensureCanChange();
        this.code = code;
        return this;
    }

    @Override
    public synchronized int code() {
        return this.code;
    }

    @Override
    public Map<String, String> headers() {
        return this.isReadOnly() ? Collections.unmodifiableMap(this.headers) : this.headers;
    }

    @Override
    public Resp header(String name, String value) {
        this.headers().put(name, value);
        return this;
    }

    @Override
    public Map<String, String> cookies() {
        return this.isReadOnly() ? Collections.unmodifiableMap(this.cookies) : this.cookies;
    }

    @Override
    public Resp cookie(String name, String value, String ... extras) {
        if (U.notEmpty((Object[])extras)) {
            value = value + "; " + U.join((String)"; ", (Object[])extras);
        }
        if (!RespImpl.cookieContainsPath(extras)) {
            value = value + "; path=" + HttpUtils.cookiePath();
        }
        this.cookies().put(name, value);
        return this;
    }

    private static boolean cookieContainsPath(String[] extras) {
        for (String extra : extras) {
            if (!extra.toLowerCase().startsWith("path=")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Serializable> session() {
        return this.request().session();
    }

    @Override
    public Resp session(String name, Serializable value) {
        this.session().put(name, value);
        return this;
    }

    @Override
    public Map<String, Serializable> token() {
        return this.request().token();
    }

    @Override
    public Resp token(String name, Serializable value) {
        this.token().put(name, value);
        return this;
    }

    @Override
    public Map<String, Object> model() {
        return this.isReadOnly() ? Collections.unmodifiableMap(this.model) : this.model;
    }

    @Override
    public Resp model(String name, Object value) {
        this.model().put(name, value);
        return this;
    }

    @Override
    public synchronized Resp contentType(MediaType contentType) {
        this.ensureCanChange();
        this.contentType = contentType;
        return this;
    }

    @Override
    public synchronized MediaType contentType() {
        return this.contentType;
    }

    @Override
    public synchronized Resp redirect(String redirect) {
        this.ensureCanChange();
        this.redirect = redirect;
        return this;
    }

    @Override
    public synchronized String redirect() {
        return this.redirect;
    }

    @Override
    public synchronized Resp filename(String filename) {
        this.ensureCanChange();
        this.filename = filename;
        return this;
    }

    @Override
    public synchronized String filename() {
        return this.filename;
    }

    @Override
    public synchronized Resp file(File file) {
        this.ensureCanChange();
        this.file = file;
        return this;
    }

    @Override
    public synchronized File file() {
        return this.file;
    }

    private void ensureCanChange() {
        U.must((!this.req.isDone() ? 1 : 0) != 0, (String)"The request was already processed, so the response can't be changed now!");
        U.must((!this.req.isRendering() ? 1 : 0) != 0, (String)"The response rendering has already started, so the response can't be changed now!");
    }

    private boolean isReadOnly() {
        return this.req.isRendering() || this.req.isDone();
    }

    @Override
    public Resp done() {
        this.req.done();
        return this;
    }

    @Override
    public Resp html(Object content) {
        return this.contentType(MediaType.HTML_UTF_8).result(content);
    }

    @Override
    public Resp plain(Object content) {
        return this.contentType(MediaType.PLAIN_TEXT_UTF_8).result(content);
    }

    @Override
    public Resp json(Object content) {
        return this.contentType(MediaType.JSON).result(content);
    }

    @Override
    public Resp binary(Object content) {
        return this.contentType(MediaType.BINARY).result(content);
    }

    @Override
    public synchronized String view() {
        return this.view != null ? this.view : HttpUtils.viewName(this.req);
    }

    @Override
    public Resp noView() {
        return this.view("");
    }

    boolean hasCustomView() {
        return this.view != null;
    }

    @Override
    public synchronized Resp view(String view) {
        if (view != null) {
            HttpUtils.validateViewName(view);
            this.mvc(true);
        }
        this.view = view;
        return this;
    }

    @Override
    public synchronized boolean mvc() {
        return this.mvc;
    }

    @Override
    public synchronized Resp mvc(boolean mvc) {
        if (mvc) {
            U.must((boolean)MscOpts.hasRapidoidHTML(), (String)"The rapidoid-html module must be included for the MVC feature!");
        }
        this.mvc = mvc;
        return this;
    }

    @Override
    public Req request() {
        return this.req;
    }

    @Override
    public boolean login(String username, String password) {
        boolean success;
        LoginProvider loginProvider = Customization.of(this.req).loginProvider();
        U.must((loginProvider != null ? 1 : 0) != 0, (String)"A login provider wasn't set!");
        RolesProvider rolesProvider = Customization.of(this.req).rolesProvider();
        U.must((rolesProvider != null ? 1 : 0) != 0, (String)"A roles provider wasn't set!");
        this.req.tokenChanged.set(true);
        try {
            success = loginProvider.login(this.req, username, password);
            if (success) {
                Set<String> roles = rolesProvider.getRolesForUser(this.req, username);
                long ttl = ((Integer)Conf.TOKEN.entry("ttl").or((Object)0)).intValue();
                long expiresOn = ttl > 0L ? U.time() + ttl : Long.MAX_VALUE;
                UserInfo user = new UserInfo(username, roles, null);
                Ctxs.required().setUser(user);
                this.request().token().put("_user", (Serializable)((Object)username));
                this.request().token().put("_expires", Long.valueOf(expiresOn));
            }
        }
        catch (Throwable e) {
            throw U.rte((String)"Login error!", (Throwable)e);
        }
        return success;
    }

    @Override
    public void logout() {
        HttpUtils.clearUserData(this.request());
        HttpUtils.setResponseTokenCookie(this, "");
        this.req.tokenChanged.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Screen screen() {
        if (this.screen == null) {
            RespImpl respImpl = this;
            synchronized (respImpl) {
                if (this.screen == null) {
                    this.screen = this.createScreen();
                }
            }
        }
        return this.screen;
    }

    @Override
    public void resume(AsyncLogic asyncLogic) {
        this.req.channel().resume(this.req.connectionId(), this.req.handle(), asyncLogic);
    }

    private Screen createScreen() {
        Screen screen = MscOpts.hasRapidoidGUI() ? GUIUtil.newPage() : new ScreenBean();
        this.initScreen(screen);
        return screen;
    }

    private void initScreen(Screen screen) {
        BasicConfig zone = HttpUtils.zone(this.req);
        String brand = (String)zone.entry("brand").str().getOrNull();
        String title = (String)zone.entry("title").str().getOrNull();
        String siteName = this.req.host();
        if (U.isEmpty((String)siteName) || siteName.equals("localhost") || siteName.startsWith("localhost:") || siteName.equals("127.0.0.1") || siteName.startsWith("127.0.0.1:")) {
            siteName = "Rapidoid";
        }
        screen.brand(U.or((Object)brand, (Object)siteName));
        screen.title((String)U.or((Object)title, (Object)siteName));
        screen.home((String)zone.entry("home").str().or((Object)"/"));
        screen.search(((Boolean)zone.entry("search").bool().or((Object)false)).booleanValue());
        screen.navbar(((Boolean)zone.entry("navbar").bool().or((Object)(brand != null ? 1 : 0))).booleanValue());
        screen.fluid(((Boolean)zone.entry("fluid").bool().or((Object)false)).booleanValue());
        String cdn = (String)zone.entry("cdn").or((Object)"auto");
        if (!"auto".equalsIgnoreCase(cdn)) {
            screen.cdn(Cls.bool((Object)cdn));
        }
        if (zone.has("menu")) {
            screen.menu(zone.sub(new String[]{"menu"}).toMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream out() {
        if (this.chunked == null) {
            RespImpl respImpl = this;
            synchronized (respImpl) {
                if (this.chunked == null) {
                    this.checkStreamingPreconditions();
                    this.chunked = new ChunkedResponse(this);
                    this.header("Transfer-Encoding", "chunked");
                }
            }
        }
        return this.chunked;
    }

    private void checkStreamingPreconditions() {
        U.must((this.result() == null ? 1 : 0) != 0, (String)"The response result has already been set, so cannot write the response through OutputStream, too!");
        U.must((this.body() == null ? 1 : 0) != 0, (String)"The response body has already been set, so cannot write the response through OutputStream, too!");
        U.must((this.raw() == null ? 1 : 0) != 0, (String)"The raw response has already been set, so cannot write the response through OutputStream, too!");
    }

    void startChunkedOutputStream() {
        this.req.doRendering(this.code(), null);
    }

    public String toString() {
        return "RespImpl{" + (this.result != null ? "result=" + this.result : "") + (this.body != null ? ", body=" + this.body : "") + (this.raw != null ? ", raw=" + this.raw : "") + ", code=" + this.code + (this.contentType != null ? ", contentType=" + this.contentType : "") + ", headers=" + this.headers + ", cookies=" + this.cookies + ", model=" + this.model + (this.redirect != null ? ", redirect='" + this.redirect + '\'' : "") + (this.filename != null ? ", filename='" + this.filename + '\'' : "") + (this.file != null ? ", file=" + this.file : "") + (this.view != null ? ", view='" + this.view + '\'' : "") + ", mvc=" + this.mvc + '}';
    }

    byte[] renderToBytes() {
        if (this.mvc()) {
            byte[] bytes = ResponseRenderer.renderMvc(this.req, this);
            HttpUtils.postProcessResponse(this);
            return bytes;
        }
        if (this.body() != null) {
            return Msc.toBytes((Object)this.body());
        }
        if (this.result() != null) {
            return this.serializeResponseContent();
        }
        throw U.rte((String)"There's nothing to render!");
    }

    private byte[] serializeResponseContent() {
        return HttpUtils.responseToBytes(this.req, this.result(), this.contentType(), Customization.of(this.req).jsonResponseRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resp chunk(byte[] data) {
        OutputStream chnk;
        OutputStream outputStream = chnk = this.out();
        synchronized (outputStream) {
            try {
                chnk.flush();
            }
            catch (IOException e) {
                throw U.rte((Throwable)e);
            }
            this.chunk(data, 0, data.length);
        }
        return this;
    }

    public void chunk(final byte[] data, final int offset, final int length) {
        U.notNull((Object)data, (String)"data", (Object[])new Object[0]);
        this.resume(new AsyncLogic(){

            public boolean resumeAsync() {
                Buf out = RespImpl.this.req.channel().output();
                out.append(Integer.toHexString(length));
                out.append("\r\n");
                out.append(data, offset, length);
                out.append("\r\n");
                RespImpl.this.req.channel().send();
                return false;
            }
        });
    }

    void terminatingChunk() {
        this.resume(new AsyncLogic(){

            public boolean resumeAsync() {
                Buf out = RespImpl.this.req.channel().output();
                out.append("0\r\n\r\n");
                return true;
            }
        });
    }

    void finish() {
        if (this.chunked != null && !this.chunked.isClosed()) {
            IO.close((Closeable)this.chunked, (boolean)false);
        }
    }
}

