/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.cache.Cache;
import org.rapidoid.collection.Coll;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigImpl;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.NotFound;
import org.rapidoid.http.Req;
import org.rapidoid.http.Route;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.HttpResponseRenderer;
import org.rapidoid.http.handler.HttpHandler;
import org.rapidoid.http.impl.CachedResp;
import org.rapidoid.http.impl.HTTPCacheKey;
import org.rapidoid.http.impl.HandlerMatch;
import org.rapidoid.http.impl.HttpParser;
import org.rapidoid.http.impl.HttpRoutesImpl;
import org.rapidoid.http.impl.ReqImpl;
import org.rapidoid.http.impl.RespBodyBuffer;
import org.rapidoid.http.impl.RespBodyBytes;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.http.processor.AbstractHttpProcessor;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.abstracts.IRequest;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class FastHttp
extends AbstractHttpProcessor {
    private static final HttpParser HTTP_PARSER = new HttpParser();
    private static final String INTERNAL_SERVER_ERROR = "Internal Server Error!";
    private static final byte[] BUILT_IN_RES_PATH = "/_rapidoid/".getBytes();
    private final HttpRoutesImpl routes;
    private final Map<String, Object> attributes = Coll.synchronizedMap();

    public FastHttp(HttpRoutesImpl routes) {
        this(routes, (Config)new ConfigImpl());
    }

    public FastHttp(HttpRoutesImpl routes, Config serverConfig) {
        super(null);
        this.routes = routes;
        routes.setHttp(this);
    }

    @Override
    public void onRequest(Channel channel, RapidoidHelper data) {
        ReqImpl req;
        HttpStatus status;
        boolean isKeepAlive;
        block13: {
            HandlerMatch match;
            Buf buf = channel.input();
            boolean isGet = data.isGet.value;
            isKeepAlive = data.isKeepAlive.value;
            BufRange verb = data.verb;
            BufRange uri = data.uri;
            BufRange path = data.path;
            HttpIO.INSTANCE.removeTrailingSlash(buf, path);
            HttpIO.INSTANCE.removeTrailingSlash(buf, uri);
            String err = this.validateRequest(buf, verb, uri);
            if (err != null) {
                HttpIO.INSTANCE.writeBadRequest(channel);
                return;
            }
            status = HttpStatus.NOT_FOUND;
            Route matchingRoute = null;
            if (isGet && this.shouldServeBuiltInResources(buf, path)) {
                match = this.routes.builtInResourcesHandler();
                if (match != null) {
                    matchingRoute = match.getRoute();
                }
            } else {
                match = this.routes.findHandler(buf, isGet, verb, path);
                if (match != null) {
                    matchingRoute = match.getRoute();
                }
                if (match == null && isGet && (match = this.routes.staticResourcesHandler()) != null) {
                    matchingRoute = match.getRoute();
                }
            }
            HttpHandler handler = match != null ? match.getHandler() : null;
            boolean noReq = handler != null && !handler.needsParams();
            req = null;
            if (!noReq && this.serveFromCache(req = this.createReq(channel, isGet, isKeepAlive, data, buf, matchingRoute, match, handler))) {
                return;
            }
            try {
                if (handler != null) {
                    status = this.handleIfFound(channel, isKeepAlive, handler, req);
                }
                if (status == HttpStatus.NOT_FOUND) {
                    status = this.tryGenericHandlers(channel, isKeepAlive, req);
                }
            }
            catch (Throwable e) {
                if (!this.handleError(channel, isKeepAlive, req, e)) break block13;
                return;
            }
        }
        if (status == HttpStatus.NOT_FOUND) {
            this.handleNotFound(channel, isKeepAlive, req);
            return;
        }
        if (status != HttpStatus.ASYNC) {
            channel.closeIf(!isKeepAlive);
        }
    }

    private boolean shouldServeBuiltInResources(Buf buf, BufRange path) {
        return path.length > BUILT_IN_RES_PATH.length && buf.get(path.start + 1) == 95 && BytesUtil.startsWith((Bytes)buf.bytes(), (BufRange)path, (byte[])BUILT_IN_RES_PATH, (boolean)true);
    }

    @Override
    public void waitToInitialize() {
        this.routes.waitToStabilize();
    }

    private boolean serveFromCache(ReqImpl req) {
        Cache<HTTPCacheKey, CachedResp> cache;
        HTTPCacheKey cacheKey = req.cacheKey();
        Route route = req.route();
        if (route != null && (cache = route.cache()) != null) {
            if (cacheKey != null) {
                CachedResp resp = (CachedResp)((Object)cache.getIfExists((Object)cacheKey));
                if (resp != null) {
                    this.serveCached(req, resp);
                    return true;
                }
            } else {
                cache.bypass();
            }
        }
        return false;
    }

    private void serveCached(ReqImpl req, CachedResp resp) {
        Channel channel = req.channel();
        req.cached(true);
        HttpIO.INSTANCE.respond(HttpUtils.req(req), channel, -1L, -1L, resp.statusCode, req.isKeepAlive(), resp.contentType, new RespBodyBuffer(resp.body.duplicate()), resp.headers, null);
        ((Channel)channel.send()).closeIf(!req.isKeepAlive());
    }

    public ReqImpl createReq(Channel channel, boolean isGet, boolean isKeepAlive, RapidoidHelper helper, Buf buf, Route matchingRoute, HandlerMatch match, HttpHandler handler) {
        Map files;
        Map<String, Object> posted;
        byte[] body;
        KeyValueRanges paramsKV = helper.params.reset();
        KeyValueRanges headersKV = helper.headersKV.reset();
        KeyValueRanges cookiesKV = helper.cookies.reset();
        HTTP_PARSER.parseParams(buf, paramsKV, helper.query);
        Map<String, String> params = (Map<String, String>)U.cast((Object)paramsKV.toMap(buf, true, true, false));
        if (match != null && match.getParams() != null) {
            params.putAll(match.getParams());
        }
        HTTP_PARSER.parseHeadersIntoKV(buf, helper.headers, headersKV, cookiesKV, helper);
        Map<String, String> headers = (Map<String, String>)U.cast((Object)headersKV.toMap(buf, false, false, true));
        Map<String, String> cookies = (Map<String, String>)U.cast((Object)cookiesKV.toMap(buf, false, false, false));
        boolean pendingBodyParsing = false;
        if (!isGet && !helper.body.isEmpty()) {
            KeyValueRanges postedKV = helper.pairs3.reset();
            body = helper.body.bytes(buf);
            posted = U.map();
            files = U.map();
            pendingBodyParsing = !HTTP_PARSER.parsePosted(buf, headersKV, helper.body, postedKV, files, helper, posted);
            posted = Collections.synchronizedMap(posted);
            files = Collections.synchronizedMap(files);
        } else {
            posted = Collections.EMPTY_MAP;
            files = Collections.EMPTY_MAP;
            body = null;
        }
        String verb = helper.verb.str(buf);
        String uri = helper.uri.str(buf);
        String path = Msc.urlDecode((String)helper.path.str(buf));
        String query = Msc.urlDecodeOrKeepOriginal((String)helper.query.str(buf));
        String zone = null;
        MediaType contentType = HttpUtils.getDefaultContentType();
        if (handler != null) {
            contentType = handler.contentType();
            zone = handler.options().zone();
        }
        zone = (String)U.or(zone, (Object)"main");
        params = Collections.synchronizedMap(params);
        headers = Collections.synchronizedMap(headers);
        cookies = Collections.synchronizedMap(cookies);
        ReqImpl req = new ReqImpl(this, channel, isKeepAlive, verb, uri, path, query, body, params, headers, cookies, posted, files, pendingBodyParsing, contentType, zone, matchingRoute);
        if (!this.attributes.isEmpty()) {
            req.attrs().putAll(this.attributes);
        }
        channel.setRequest((IRequest)req);
        return req;
    }

    private HttpStatus handleIfFound(Channel channel, boolean isKeepAlive, HttpHandler handler, Req req) {
        try {
            return handler.handle(channel, isKeepAlive, req);
        }
        catch (NotFound nf) {
            return HttpStatus.NOT_FOUND;
        }
    }

    private void internalServerError(Channel channel, boolean isKeepAlive, Req req) {
        MediaType contentType = req != null ? req.contentType() : HttpUtils.getDefaultContentType();
        HttpResponseRenderer jsonRenderer = Customization.of(req).jsonResponseRenderer();
        RespBodyBytes body = new RespBodyBytes(HttpUtils.responseToBytes(req, INTERNAL_SERVER_ERROR, contentType, jsonRenderer));
        HttpIO.INSTANCE.respond(HttpUtils.maybe(req), channel, -1L, -1L, 500, isKeepAlive, contentType, body, null, null);
    }

    private boolean handleError(Channel channel, boolean isKeepAlive, Req req, Throwable e) {
        if (req != null) {
            if (!((ReqImpl)req).isStopped()) {
                try {
                    HttpIO.INSTANCE.errorAndDone(req, e, LogLevel.ERROR);
                }
                catch (Exception e1) {
                    Log.error((String)"HTTP error handler error!", (Throwable)e1);
                    this.internalServerError(channel, isKeepAlive, req);
                }
            }
            return true;
        }
        Log.error((String)"Low-level HTTP handler error!", (Throwable)e);
        this.internalServerError(channel, isKeepAlive, null);
        return false;
    }

    private void handleNotFound(Channel channel, boolean isKeepAlive, Req req) {
        this.handleError(channel, isKeepAlive, req, new NotFound());
    }

    public Customization custom() {
        return this.routes.custom();
    }

    private String validateRequest(Buf input, BufRange verb, BufRange uri) {
        if (verb.isEmpty()) {
            return "HTTP verb cannot be empty!";
        }
        if (!BytesUtil.isValidURI((Bytes)input.bytes(), (BufRange)uri)) {
            return "Invalid HTTP URI!";
        }
        return null;
    }

    private HttpStatus tryGenericHandlers(Channel channel, boolean isKeepAlive, ReqImpl req) {
        for (HttpHandler handler : this.routes.genericHandlers()) {
            HttpStatus status = this.handleIfFound(channel, isKeepAlive, handler, req);
            if (status == HttpStatus.NOT_FOUND) continue;
            return status;
        }
        return HttpStatus.NOT_FOUND;
    }

    public synchronized void resetConfig() {
        this.routes.reset();
    }

    public void notFound(Channel ctx, boolean isKeepAlive, MediaType contentType, HttpHandler fromHandler, Req req) {
        HttpStatus status = HttpStatus.NOT_FOUND;
        List<HttpHandler> genericHandlers = this.routes.genericHandlers();
        int count = genericHandlers.size();
        for (int i = 0; i < count; ++i) {
            HttpHandler handler = genericHandlers.get(i);
            if (handler != fromHandler || i >= count - 1) continue;
            HttpHandler nextHandler = genericHandlers.get(i + 1);
            status = this.handleIfFound(ctx, isKeepAlive, nextHandler, req);
            break;
        }
        if (status == HttpStatus.NOT_FOUND) {
            this.handleNotFound(ctx, isKeepAlive, req);
        }
    }

    public Map<String, Object> attributes() {
        return this.attributes;
    }

    public HttpRoutesImpl routes() {
        return this.routes;
    }

    public boolean hasRouteOrResource(HttpVerb verb, String uri) {
        return this.routes.hasRouteOrResource(verb, uri);
    }
}

