/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.customize.defaults;

import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.BasicConfig;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.NotFound;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.ErrorHandler;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class DefaultErrorHandler
extends RapidoidThing
implements ErrorHandler {
    @Override
    public Object handleError(Req req, Resp resp, Throwable error) {
        resp.result(null);
        Customization custom = Customization.of(req);
        Object result = this.handleError(req, resp, error, custom);
        if (result instanceof Throwable) {
            Throwable errResult = (Throwable)result;
            return this.renderError(req, resp, errResult);
        }
        return result;
    }

    private Object renderError(Req req, Resp resp, Throwable error) {
        if (resp.contentType() == MediaType.JSON) {
            return HttpUtils.getErrorInfo(resp, error);
        }
        if (resp.contentType() == MediaType.PLAIN_TEXT_UTF_8) {
            return HttpUtils.getErrorMessageAndSetCode(resp, error);
        }
        return this.page(req, resp, error);
    }

    protected Object handleError(Req req, Resp resp, Throwable error, Customization custom) {
        int i = 0;
        while (true) {
            resp.result(null);
            ErrorHandler handler = custom.findErrorHandlerByType(error);
            try {
                Object result = null;
                if (handler != null) {
                    result = handler.handleError(req, resp, error);
                }
                return result != null ? result : this.defaultErrorHandling(req, error);
            }
            catch (Exception e) {
                if (i >= this.getMaxReThrowCount(req)) {
                    return U.rte((String)"Too many times an error was re-thrown by the error handler(s)!");
                }
                error = e;
                ++i;
                continue;
            }
            break;
        }
    }

    protected int getMaxReThrowCount(Req req) {
        return 5;
    }

    protected Object defaultErrorHandling(Req req, Throwable error) {
        if (error instanceof NotFound) {
            Resp resp = req.response().code(404);
            if (resp.contentType() == MediaType.JSON) {
                return error;
            }
            return resp.view("404").result(U.map((Object)"req", (Object)req));
        }
        return error;
    }

    protected Object page(Req req, Resp resp, Throwable error) {
        if (error instanceof SecurityException) {
            resp.model("embedded", req.attr("_embedded", false));
            resp.model("req", req);
            resp.model("loginUri", Msc.specialUri((String[])new String[]{"login"}));
            return resp.code(403).view("login").mvc(true);
        }
        BasicConfig zone = HttpUtils.zone(req);
        String home = (String)zone.entry("home").or((Object)"/");
        Map<String, ?> errorInfo = HttpUtils.getErrorInfo(resp, error);
        resp.model("req", req);
        resp.model("error", errorInfo);
        resp.model("home", home);
        return resp.mvc(true).view("error");
    }
}

