/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import org.rapidoid.RapidoidThing;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.RespBody;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.HttpResponseRenderer;
import org.rapidoid.http.impl.ReqImpl;
import org.rapidoid.http.impl.RespBodyBytes;
import org.rapidoid.http.impl.RespImpl;
import org.rapidoid.http.impl.ResponseRenderer;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class BodyRenderer
extends RapidoidThing {
    static RespBody toRespBody(Req req, RespImpl resp) {
        try {
            return BodyRenderer.createRespBodyFromResult(req, resp);
        }
        catch (Throwable e) {
            HttpIO.INSTANCE.error(req, e, LogLevel.ERROR);
            try {
                return BodyRenderer.createRespBodyFromResult(req, resp);
            }
            catch (Exception e1) {
                Log.error((String)"Internal rendering error!", (Throwable)e1);
                return new RespBodyBytes(HttpUtils.getErrorMessageAndSetCode(resp, e1).getBytes());
            }
        }
    }

    private static RespBody createRespBodyFromResult(Req req, RespImpl resp) {
        Object result = resp.result();
        Object body = resp.body();
        if (result instanceof RespBody) {
            return (RespBody)result;
        }
        if (body instanceof RespBody) {
            return (RespBody)body;
        }
        if (resp.mvc()) {
            byte[] bytes = ResponseRenderer.renderMvc((ReqImpl)req, resp);
            HttpUtils.postProcessResponse(resp);
            return new RespBodyBytes(bytes);
        }
        if (body != null) {
            return new RespBodyBytes(Msc.toBytes((Object)body));
        }
        if (result != null) {
            return BodyRenderer.resultToRespBody(resp, result);
        }
        throw U.rte((String)"There's nothing to render!");
    }

    public static RespBody resultToRespBody(Resp resp, Object result) {
        if (result instanceof RespBody) {
            return (RespBody)result;
        }
        byte[] bytes = HttpUtils.responseToBytes(resp.request(), result, resp.contentType(), BodyRenderer.mediaResponseRenderer(resp));
        return new RespBodyBytes(bytes);
    }

    private static HttpResponseRenderer mediaResponseRenderer(Resp resp) {
        Customization customization = Customization.of(resp.request());
        if (resp.contentType().equals((Object)MediaType.JSON)) {
            return customization.jsonResponseRenderer();
        }
        if (resp.contentType().equals((Object)MediaType.XML_UTF_8)) {
            return customization.xmlResponseRenderer();
        }
        return customization.jsonResponseRenderer();
    }
}

