/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.rapidoid.http.impl.RespImpl;
import org.rapidoid.util.Once;
import org.rapidoid.writable.ReusableWritable;

public class ChunkedResponse
extends OutputStream {
    private final RespImpl resp;
    private final ReusableWritable chunk = new ReusableWritable();
    private volatile Once startChunkedResp = new Once();
    private volatile boolean closed;

    ChunkedResponse(RespImpl resp) {
        this.resp = resp;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.chunk.write(b);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.chunk.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.chunk.write(b, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.startChunkedResp.go()) {
            this.resp.startChunkedOutputStream();
        }
        if (this.chunk.size() > 0) {
            this.resp.chunk(this.chunk.array(), 0, this.chunk.size());
            this.chunk.reset();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.resp.terminatingChunk();
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }
}

