/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.TransactionMode;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bufstruct.BufMap;
import org.rapidoid.bufstruct.BufMapImpl;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Err;
import org.rapidoid.commons.Str;
import org.rapidoid.data.BufRange;
import org.rapidoid.env.Env;
import org.rapidoid.http.FastHttp;
import org.rapidoid.http.HttpRoutes;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.http.ReqHandler;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.http.Route;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.handler.HttpHandler;
import org.rapidoid.http.handler.ParamsAwareReqHandler;
import org.rapidoid.http.handler.ParamsAwareReqRespHandler;
import org.rapidoid.http.handler.StaticResourcesHandler;
import org.rapidoid.http.impl.HandlerMatch;
import org.rapidoid.http.impl.HandlerMatchWithParams;
import org.rapidoid.http.impl.PathPattern;
import org.rapidoid.http.impl.RouteImpl;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.io.Res;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.AnsiColor;
import org.rapidoid.util.Msc;

public class HttpRoutesImpl
extends RapidoidThing
implements HttpRoutes {
    private static final AtomicLong ID_GEN = new AtomicLong();
    private static final int ROUTE_SETUP_WAITING_TIME_MS = Env.test() ? 0 : 500;
    private static final byte[] _POST = "POST".getBytes();
    private static final byte[] _PUT = "PUT".getBytes();
    private static final byte[] _DELETE = "DELETE".getBytes();
    private static final byte[] _PATCH = "PATCH".getBytes();
    private static final byte[] _OPTIONS = "OPTIONS".getBytes();
    private static final byte[] _HEAD = "HEAD".getBytes();
    private static final byte[] _TRACE = "TRACE".getBytes();
    final BufMap<HttpHandler> getHandlers = new BufMapImpl();
    final BufMap<HttpHandler> postHandlers = new BufMapImpl();
    final BufMap<HttpHandler> putHandlers = new BufMapImpl();
    final BufMap<HttpHandler> deleteHandlers = new BufMapImpl();
    final BufMap<HttpHandler> patchHandlers = new BufMapImpl();
    final BufMap<HttpHandler> optionsHandlers = new BufMapImpl();
    final BufMap<HttpHandler> headHandlers = new BufMapImpl();
    final BufMap<HttpHandler> traceHandlers = new BufMapImpl();
    final BufMap<HttpHandler> anyHandlers = new BufMapImpl();
    final Map<PathPattern, HttpHandler> patternGetHandlers = new TreeMap<PathPattern, HttpHandler>();
    final Map<PathPattern, HttpHandler> patternPostHandlers = new TreeMap<PathPattern, HttpHandler>();
    final Map<PathPattern, HttpHandler> patternPutHandlers = new TreeMap<PathPattern, HttpHandler>();
    final Map<PathPattern, HttpHandler> patternDeleteHandlers = new TreeMap<PathPattern, HttpHandler>();
    final Map<PathPattern, HttpHandler> patternPatchHandlers = new TreeMap<PathPattern, HttpHandler>();
    final Map<PathPattern, HttpHandler> patternOptionsHandlers = new TreeMap<PathPattern, HttpHandler>();
    final Map<PathPattern, HttpHandler> patternHeadHandlers = new TreeMap<PathPattern, HttpHandler>();
    final Map<PathPattern, HttpHandler> patternTraceHandlers = new TreeMap<PathPattern, HttpHandler>();
    final Map<PathPattern, HttpHandler> patternAnyHandlers = new TreeMap<PathPattern, HttpHandler>();
    private final long id;
    private final String setupName;
    private final Customization customization;
    private volatile byte[] path1;
    private volatile byte[] path2;
    private volatile byte[] path3;
    private volatile HttpHandler handler1;
    private volatile HttpHandler handler2;
    private volatile HttpHandler handler3;
    final List<HttpHandler> genericHandlers = Coll.synchronizedList((Object[])new HttpHandler[0]);
    private volatile HttpHandler staticResourcesHandler;
    private volatile HttpHandler builtInResourcesHandler;
    private final Set<Route> routes = Coll.synchronizedSet((Object[])new Route[0]);
    private volatile boolean initialized;
    private volatile Runnable onInit;
    private volatile boolean stable;
    private volatile Date lastChangedAt = new Date();
    private volatile FastHttp http;

    public HttpRoutesImpl(String setupName, Customization customization) {
        this.id = ID_GEN.incrementAndGet();
        this.setupName = setupName;
        this.customization = customization;
        this.staticResourcesHandler = new StaticResourcesHandler(customization);
        this.builtInResourcesHandler = new StaticResourcesHandler(customization);
    }

    private void register(HttpVerb verb, String path, HttpHandler handler) {
        boolean isPattern = PathPattern.isPattern(path);
        PathPattern pathPattern = isPattern ? PathPattern.from(path) : null;
        RouteImpl route = new RouteImpl(verb, path, handler, handler.options());
        handler.setRoute(route);
        this.routes.add(route);
        switch (verb) {
            case GET: {
                if (!isPattern) {
                    if (this.path1 == null) {
                        this.path1 = path.getBytes();
                        this.handler1 = handler;
                        break;
                    }
                    if (this.path2 == null) {
                        this.path2 = path.getBytes();
                        this.handler2 = handler;
                        break;
                    }
                    if (this.path3 == null) {
                        this.path3 = path.getBytes();
                        this.handler3 = handler;
                        break;
                    }
                    this.getHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternGetHandlers.put(pathPattern, handler);
                break;
            }
            case POST: {
                if (!isPattern) {
                    this.postHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternPostHandlers.put(pathPattern, handler);
                break;
            }
            case PUT: {
                if (!isPattern) {
                    this.putHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternPutHandlers.put(pathPattern, handler);
                break;
            }
            case DELETE: {
                if (!isPattern) {
                    this.deleteHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternDeleteHandlers.put(pathPattern, handler);
                break;
            }
            case PATCH: {
                if (!isPattern) {
                    this.patchHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternPatchHandlers.put(pathPattern, handler);
                break;
            }
            case OPTIONS: {
                if (!isPattern) {
                    this.optionsHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternOptionsHandlers.put(pathPattern, handler);
                break;
            }
            case HEAD: {
                if (!isPattern) {
                    this.headHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternHeadHandlers.put(pathPattern, handler);
                break;
            }
            case TRACE: {
                if (!isPattern) {
                    this.traceHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternTraceHandlers.put(pathPattern, handler);
                break;
            }
            case ANY: {
                if (!isPattern) {
                    this.anyHandlers.put(path, (Object)handler);
                    break;
                }
                this.patternAnyHandlers.put(pathPattern, handler);
                break;
            }
            default: {
                throw Err.notExpected();
            }
        }
        this.notifyChanged();
    }

    private void deregister(HttpVerb verb, String path) {
        boolean isPattern = PathPattern.isPattern(path);
        PathPattern pathPattern = isPattern ? PathPattern.from(path) : null;
        this.routes.remove(RouteImpl.matching(verb, path));
        switch (verb) {
            case GET: {
                if (!isPattern) {
                    if (this.path1 != null && new String(this.path1).equals(path)) {
                        this.path1 = null;
                    }
                    if (this.path2 != null && new String(this.path2).equals(path)) {
                        this.path2 = null;
                    }
                    if (this.path3 != null && new String(this.path3).equals(path)) {
                        this.path3 = null;
                    }
                    this.getHandlers.remove(path);
                    break;
                }
                this.patternGetHandlers.remove(pathPattern);
                break;
            }
            case POST: {
                if (!isPattern) {
                    this.postHandlers.remove(path);
                    break;
                }
                this.patternPostHandlers.remove(pathPattern);
                break;
            }
            case PUT: {
                if (!isPattern) {
                    this.putHandlers.remove(path);
                    break;
                }
                this.patternPutHandlers.remove(pathPattern);
                break;
            }
            case DELETE: {
                if (!isPattern) {
                    this.deleteHandlers.remove(path);
                    break;
                }
                this.patternDeleteHandlers.remove(pathPattern);
                break;
            }
            case PATCH: {
                if (!isPattern) {
                    this.patchHandlers.remove(path);
                    break;
                }
                this.patternPatchHandlers.remove(pathPattern);
                break;
            }
            case OPTIONS: {
                if (!isPattern) {
                    this.optionsHandlers.remove(path);
                    break;
                }
                this.patternOptionsHandlers.remove(pathPattern);
                break;
            }
            case HEAD: {
                if (!isPattern) {
                    this.headHandlers.remove(path);
                    break;
                }
                this.patternHeadHandlers.remove(pathPattern);
                break;
            }
            case TRACE: {
                if (!isPattern) {
                    this.traceHandlers.remove(path);
                    break;
                }
                this.patternTraceHandlers.remove(pathPattern);
                break;
            }
            case ANY: {
                if (!isPattern) {
                    this.anyHandlers.remove(path);
                    break;
                }
                this.patternAnyHandlers.remove(pathPattern);
                break;
            }
            default: {
                throw Err.notExpected();
            }
        }
        this.notifyChanged();
    }

    @Override
    public synchronized void addGenericHandler(HttpHandler handler) {
        Log.info((String)"Registering generic handler", (String)"!setup", (Object)this.setupName);
        this.genericHandlers.add(handler);
        this.notifyChanged();
    }

    @Override
    public synchronized void removeGenericHandler(HttpHandler handler) {
        this.genericHandlers.remove(handler);
        this.notifyChanged();
    }

    public HandlerMatch findHandler(Buf buf, boolean isGet, BufRange verb, BufRange path) {
        Bytes bytes = buf.bytes();
        if (isGet) {
            if (this.path1 != null && BytesUtil.matches((Bytes)bytes, (BufRange)path, (byte[])this.path1, (boolean)true)) {
                return this.handler1;
            }
            if (this.path2 != null && BytesUtil.matches((Bytes)bytes, (BufRange)path, (byte[])this.path2, (boolean)true)) {
                return this.handler2;
            }
            if (this.path3 != null && BytesUtil.matches((Bytes)bytes, (BufRange)path, (byte[])this.path3, (boolean)true)) {
                return this.handler3;
            }
            HandlerMatch handler = (HandlerMatch)this.getHandlers.get(buf, path);
            if (handler == null) {
                handler = (HandlerMatch)this.anyHandlers.get(buf, path);
            }
            if (handler == null) {
                handler = this.matchByPattern(this.patternGetHandlers, buf.get(path));
            }
            return handler;
        }
        if (BytesUtil.matches((Bytes)bytes, (BufRange)verb, (byte[])_POST, (boolean)true)) {
            HandlerMatch handler = (HandlerMatch)this.postHandlers.get(buf, path);
            if (handler == null) {
                handler = (HandlerMatch)this.anyHandlers.get(buf, path);
            }
            if (handler == null) {
                handler = this.matchByPattern(this.patternPostHandlers, buf.get(path));
            }
            return handler;
        }
        if (BytesUtil.matches((Bytes)bytes, (BufRange)verb, (byte[])_PUT, (boolean)true)) {
            HandlerMatch handler = (HandlerMatch)this.putHandlers.get(buf, path);
            if (handler == null) {
                handler = (HandlerMatch)this.anyHandlers.get(buf, path);
            }
            if (handler == null) {
                handler = this.matchByPattern(this.patternPutHandlers, buf.get(path));
            }
            return handler;
        }
        if (BytesUtil.matches((Bytes)bytes, (BufRange)verb, (byte[])_DELETE, (boolean)true)) {
            HandlerMatch handler = (HandlerMatch)this.deleteHandlers.get(buf, path);
            if (handler == null) {
                handler = (HandlerMatch)this.anyHandlers.get(buf, path);
            }
            if (handler == null) {
                handler = this.matchByPattern(this.patternDeleteHandlers, buf.get(path));
            }
            return handler;
        }
        if (BytesUtil.matches((Bytes)bytes, (BufRange)verb, (byte[])_PATCH, (boolean)true)) {
            HandlerMatch handler = (HandlerMatch)this.patchHandlers.get(buf, path);
            if (handler == null) {
                handler = (HandlerMatch)this.anyHandlers.get(buf, path);
            }
            if (handler == null) {
                handler = this.matchByPattern(this.patternPatchHandlers, buf.get(path));
            }
            return handler;
        }
        if (BytesUtil.matches((Bytes)bytes, (BufRange)verb, (byte[])_OPTIONS, (boolean)true)) {
            HandlerMatch handler = (HandlerMatch)this.optionsHandlers.get(buf, path);
            if (handler == null) {
                handler = (HandlerMatch)this.anyHandlers.get(buf, path);
            }
            if (handler == null) {
                handler = this.matchByPattern(this.patternOptionsHandlers, buf.get(path));
            }
            return handler;
        }
        if (BytesUtil.matches((Bytes)bytes, (BufRange)verb, (byte[])_HEAD, (boolean)true)) {
            HandlerMatch handler = (HandlerMatch)this.headHandlers.get(buf, path);
            if (handler == null) {
                handler = (HandlerMatch)this.anyHandlers.get(buf, path);
            }
            if (handler == null) {
                handler = this.matchByPattern(this.patternHeadHandlers, buf.get(path));
            }
            return handler;
        }
        if (BytesUtil.matches((Bytes)bytes, (BufRange)verb, (byte[])_TRACE, (boolean)true)) {
            HandlerMatch handler = (HandlerMatch)this.traceHandlers.get(buf, path);
            if (handler == null) {
                handler = (HandlerMatch)this.anyHandlers.get(buf, path);
            }
            if (handler == null) {
                handler = this.matchByPattern(this.patternTraceHandlers, buf.get(path));
            }
            return handler;
        }
        return null;
    }

    private HandlerMatch matchByPattern(Map<PathPattern, HttpHandler> handlers, String path) {
        for (Map.Entry<PathPattern, HttpHandler> e : handlers.entrySet()) {
            PathPattern pattern = e.getKey();
            Map<String, String> params = pattern.match(path);
            if (params == null) continue;
            HttpHandler handler = e.getValue();
            Route route = handler.getRoute();
            return new HandlerMatchWithParams(handler, params, route);
        }
        if (handlers != this.patternAnyHandlers) {
            return this.matchByPattern(this.patternAnyHandlers, path);
        }
        return null;
    }

    @Override
    public synchronized void on(String verb, String path, HttpHandler handler) {
        this.addOrRemove(true, verb, path, handler);
    }

    @Override
    public synchronized void on(String verb, String path, ReqHandler handler) {
        U.notNull((Object)this.http, (String)"http", (Object[])new Object[0]);
        ParamsAwareReqHandler hnd = new ParamsAwareReqHandler(this.http, null, new RouteOptions(), handler);
        this.addOrRemove(true, verb, path, hnd);
    }

    @Override
    public synchronized void on(String verb, String path, ReqRespHandler handler) {
        U.notNull((Object)this.http, (String)"http", (Object[])new Object[0]);
        ParamsAwareReqRespHandler hnd = new ParamsAwareReqRespHandler(this.http, null, new RouteOptions(), handler);
        this.addOrRemove(true, verb, path, hnd);
    }

    @Override
    public synchronized void remove(String verb, String path) {
        this.addOrRemove(false, verb, path, null);
    }

    private void addOrRemove(boolean add, String verbs, String path, HttpHandler handler) {
        U.notNull((Object)verbs, (String)"HTTP verbs", (Object[])new Object[0]);
        U.notNull((Object)path, (String)"HTTP path", (Object[])new Object[0]);
        U.must((boolean)path.startsWith("/"), (String)"The URI must start with '/', but found: '%s'", (Object)path);
        this.initialize();
        if (add) {
            U.notNull((Object)handler, (String)"HTTP handler", (Object[])new Object[0]);
        }
        verbs = verbs.toUpperCase();
        if (path.length() > 1) {
            path = Str.trimr((String)path, (String)"/");
        }
        if (add) {
            RouteOptions opts = handler.options();
            TransactionMode txm = opts.transaction();
            String tx = txm != TransactionMode.NONE ? AnsiColor.bold((String)txm.name()) : txm.name();
            int space = Math.max(45 - verbs.length() - path.length(), 1);
            Log.info((String)(this.httpVerbColor(verbs) + AnsiColor.bold((String)(" " + path)) + Str.mul((String)" ", (int)space)), (String)"setup", (Object)this.setupName, (String)"!roles", opts.roles(), (String)"transaction", (Object)tx, (String)"mvc", (Object)opts.mvc(), (String)"cacheTTL", (Object)opts.cacheTTL());
        } else {
            Log.info((String)"Deregistering handler", (String)"setup", (Object)this.setupName, (String)"!verbs", (Object)verbs, (String)"!path", (Object)path);
        }
        for (String vrb : verbs.split(",")) {
            HttpVerb verb = HttpVerb.from((String)vrb);
            if (add) {
                this.deregister(verb, path);
                this.register(verb, path, handler);
                continue;
            }
            this.deregister(verb, path);
        }
        this.notifyChanged();
    }

    private String httpVerbColor(String verb) {
        switch (verb.toUpperCase()) {
            case "ANY": 
            case "GET,POST": {
                return AnsiColor.yellow((String)verb);
            }
            case "GET": {
                return AnsiColor.lightBlue((String)verb);
            }
        }
        return AnsiColor.lightPurple((String)verb);
    }

    @Override
    public synchronized void reset() {
        this.path3 = null;
        this.path2 = null;
        this.path1 = null;
        this.handler3 = null;
        this.handler2 = null;
        this.handler1 = null;
        this.getHandlers.clear();
        this.postHandlers.clear();
        this.putHandlers.clear();
        this.deleteHandlers.clear();
        this.optionsHandlers.clear();
        this.anyHandlers.clear();
        this.genericHandlers.clear();
        this.patternGetHandlers.clear();
        this.patternPostHandlers.clear();
        this.patternPutHandlers.clear();
        this.patternDeleteHandlers.clear();
        this.patternPatchHandlers.clear();
        this.patternOptionsHandlers.clear();
        this.patternHeadHandlers.clear();
        this.patternTraceHandlers.clear();
        this.patternAnyHandlers.clear();
        this.staticResourcesHandler = new StaticResourcesHandler(this.customization);
        this.routes.clear();
        this.initialized = false;
        this.onInit = null;
        this.customization.reset();
        this.stable = false;
        this.lastChangedAt = null;
        this.notifyChanged();
    }

    @Override
    public Set<Route> all() {
        return Collections.unmodifiableSet(this.routes);
    }

    @Override
    public Set<Route> allAdmin() {
        Set routes = U.set(this.all());
        Iterator it = routes.iterator();
        while (it.hasNext()) {
            Route route = (Route)it.next();
            if (route.config().zone().equalsIgnoreCase("admin")) continue;
            it.remove();
        }
        return routes;
    }

    @Override
    public Set<Route> allNonAdmin() {
        Set routes = U.set(this.all());
        Iterator it = routes.iterator();
        while (it.hasNext()) {
            Route route = (Route)it.next();
            if (!route.config().zone().equalsIgnoreCase("admin")) continue;
            it.remove();
        }
        return routes;
    }

    @Override
    public Customization custom() {
        return this.customization;
    }

    @Override
    public Route find(HttpVerb verb, String path) {
        for (Route route : this.all()) {
            if (!route.verb().equals((Object)verb) || !route.path().equals(path)) continue;
            return route;
        }
        return null;
    }

    @Override
    public boolean hasRouteOrResource(HttpVerb verb, String uri) {
        Object[] staticFilesLocations;
        if (verb == HttpVerb.GET && U.notEmpty((Object[])(staticFilesLocations = this.custom().staticFilesPath()))) {
            String filename = Str.triml((String)uri, (char)'/');
            if (filename.isEmpty()) {
                filename = "index.html";
            }
            if (Res.from((String)filename, (String[])staticFilesLocations).exists()) {
                return true;
            }
        }
        return this.find(verb, uri) != null;
    }

    public List<HttpHandler> genericHandlers() {
        return this.genericHandlers;
    }

    public HttpHandler staticResourcesHandler() {
        return this.staticResourcesHandler;
    }

    public HttpHandler builtInResourcesHandler() {
        return this.builtInResourcesHandler;
    }

    @Override
    public Runnable onInit() {
        return this.onInit;
    }

    @Override
    public void onInit(Runnable onInit) {
        this.onInit = onInit;
        this.notifyChanged();
    }

    @Override
    public boolean isEmpty() {
        return this.routes.isEmpty() && this.genericHandlers.isEmpty() && this.staticResourcesHandler == null;
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Runnable initializer = this.onInit;
        if (initializer != null) {
            initializer.run();
        }
        this.notifyChanged();
    }

    public Date lastChangedAt() {
        return this.lastChangedAt;
    }

    private void notifyChanged() {
        this.lastChangedAt = new Date();
    }

    public boolean ready() {
        long lastChangedAt = this.lastChangedAt().getTime();
        return !this.isEmpty() && Msc.timedOut((long)lastChangedAt, (long)ROUTE_SETUP_WAITING_TIME_MS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToStabilize() {
        while (!this.stable) {
            U.sleep((long)1L);
            if (!this.ready()) continue;
            HttpRoutesImpl httpRoutesImpl = this;
            synchronized (httpRoutesImpl) {
                if (!this.stable) {
                    this.stable = true;
                    Log.debug((String)"Stabilized HTTP routes");
                }
            }
        }
    }

    public String toString() {
        return "HttpRoutesImpl{id=" + this.id + ", setup='" + this.setupName + '\'' + '}';
    }

    public void setHttp(FastHttp http) {
        this.http = http;
    }
}

