/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler.param;

import java.io.File;
import java.lang.annotation.Annotation;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.Cookie;
import org.rapidoid.annotation.Header;
import org.rapidoid.annotation.Param;
import org.rapidoid.annotation.Required;
import org.rapidoid.annotation.Valid;
import org.rapidoid.beany.Metadata;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Err;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.handler.param.BeanParamRetriever;
import org.rapidoid.http.handler.param.ByteArrayParamRetriever;
import org.rapidoid.http.handler.param.ByteArraysParamRetriever;
import org.rapidoid.http.handler.param.CookieParamRetriever;
import org.rapidoid.http.handler.param.DataParamRetriever;
import org.rapidoid.http.handler.param.HeaderParamRetriever;
import org.rapidoid.http.handler.param.ParamRetriever;
import org.rapidoid.http.handler.param.ReqParamRetriever;
import org.rapidoid.http.handler.param.RespParamRetriever;
import org.rapidoid.http.handler.param.ScreenParamRetriever;
import org.rapidoid.http.handler.param.UploadParamRetriever;
import org.rapidoid.http.handler.param.UploadsParamRetriever;
import org.rapidoid.io.Upload;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.web.Screen;

public class ParamRetrievers
extends RapidoidThing {
    public static ParamRetriever createParamRetriever(Customization customization, Class<?> type, String name, Annotation[] annotations) {
        Cookie cookie = (Cookie)Metadata.get((Annotation[])annotations, Cookie.class);
        Header header = (Header)Metadata.get((Annotation[])annotations, Header.class);
        Param param = (Param)Metadata.get((Annotation[])annotations, Param.class);
        Valid valid = (Valid)Metadata.get((Annotation[])annotations, Valid.class);
        Required required = (Required)Metadata.get((Annotation[])annotations, Required.class);
        int annotationsCount = Msc.countNonNull((Object[])new Object[]{cookie, header, param});
        U.must((annotationsCount <= 1 ? 1 : 0) != 0, (String)"Expected maximum one of the @Cookie, @Header, @Param, @P annotations on the same parameter!");
        if (annotationsCount == 1) {
            if (cookie != null) {
                return new CookieParamRetriever(type, ParamRetrievers.name(name, cookie.value()));
            }
            if (header != null) {
                return new HeaderParamRetriever(type, ParamRetrievers.name(name, header.value()));
            }
            if (param != null) {
                name = ParamRetrievers.name(name, param.value());
            } else {
                throw Err.notExpected();
            }
        }
        if (Req.class.isAssignableFrom(type)) {
            return new ReqParamRetriever();
        }
        if (Resp.class.isAssignableFrom(type)) {
            return new RespParamRetriever();
        }
        if (Screen.class.isAssignableFrom(type)) {
            return new ScreenParamRetriever();
        }
        if (type.equals(byte[].class)) {
            return new ByteArrayParamRetriever(type, name);
        }
        if (type.equals(byte[][].class)) {
            return new ByteArraysParamRetriever(type, name);
        }
        if (type.equals(Upload.class)) {
            return new UploadParamRetriever(type, name);
        }
        if (type.equals(Upload[].class)) {
            return new UploadsParamRetriever(type, name);
        }
        if (type.equals(Object.class)) {
            throw U.rte((String)"The 'Object' parameter type is too generic and not supported. Please use more specific parameter type!");
        }
        if (type.equals(File.class)) {
            throw U.rte((String)"The 'File' parameter type is not supported (yet). Try using the 'byte[]' parameter type!");
        }
        if (Cls.isAppBeanType(type)) {
            return new BeanParamRetriever(customization, type, name, valid != null);
        }
        if (Cls.kindOf(type).isConcrete()) {
            return new DataParamRetriever(type, name, required != null);
        }
        if (Cls.isDataStructure(type) || Cls.isJREClass((String)type.getCanonicalName())) {
            throw U.rte((String)"Unsupported parameter type: %s", (Object[])new Object[]{type});
        }
        return new DataParamRetriever(type, name, required != null);
    }

    private static String name(String methodParamName, String annotatedName) {
        return !U.isEmpty((String)annotatedName) ? annotatedName : methodParamName;
    }
}

