/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.reverseproxy;

import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.http.Current;
import org.rapidoid.http.HTTP;
import org.rapidoid.http.HttpClient;
import org.rapidoid.http.HttpResp;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.Req;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.http.Resp;
import org.rapidoid.http.SimpleHttpResp;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.LogLevel;
import org.rapidoid.reverseproxy.AbstractReverseProxyBean;
import org.rapidoid.reverseproxy.ProxyMapping;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ReverseProxy
extends AbstractReverseProxyBean<ReverseProxy>
implements ReqRespHandler {
    private final ProxyMapping mapping;

    public ReverseProxy(ProxyMapping mapping) {
        this.mapping = mapping;
    }

    public Object execute(Req req, Resp resp) throws Exception {
        ProxyMapping mapping = this.findMapping(req);
        if (mapping == null) {
            return null;
        }
        req.async();
        this.process(req, resp, mapping, 1, U.time());
        return req;
    }

    protected ProxyMapping findMapping(Req req) {
        return this.mapping;
    }

    private void process(final Req req, final Resp resp, final ProxyMapping mapping, final int attempts, final long since) {
        String targetUrl = mapping.getTargetUrl(req);
        Map headers = U.map((Map)req.headers());
        headers.remove("transfer-encoding");
        headers.remove("content-length");
        this.addExtraRequestHeaders(req, headers);
        HttpClient client = this.getOrCreateClient();
        client.req().verb(req.verb()).url(targetUrl).headers(headers).cookies(req.cookies()).body(req.body()).raw(true).execute((Callback)new Callback<HttpResp>(){

            public void onDone(HttpResp result, Throwable error) {
                if (error == null) {
                    resp.code(result.code());
                    resp.body(result.bodyBytes());
                    SimpleHttpResp proxyResp = new SimpleHttpResp();
                    HttpUtils.proxyResponseHeaders((Map)result.headers(), (SimpleHttpResp)proxyResp);
                    if (proxyResp.contentType != null) {
                        resp.contentType(proxyResp.contentType);
                    }
                    if (proxyResp.headers != null) {
                        resp.headers().putAll(proxyResp.headers);
                    }
                    if (proxyResp.cookies != null) {
                        resp.cookies().putAll(proxyResp.cookies);
                    }
                    resp.done();
                } else {
                    ReverseProxy.this.handleError(error, req, resp, mapping, attempts, since);
                }
            }
        });
    }

    private void addExtraRequestHeaders(Req req, Map<String, String> headers) {
        String clientIpAddress = req.clientIpAddress();
        if (this.setXUsernameHeader()) {
            headers.put("X-Username", U.safe((String)Current.username()));
        }
        if (this.setXRolesHeader()) {
            headers.put("X-Roles", U.join((String)", ", (Iterable)Current.roles()));
        }
        if (this.setXClientIPHeader()) {
            headers.put("X-Client-IP", clientIpAddress);
        }
        if (this.setXRealIPHeader()) {
            headers.put("X-Real-IP", req.realIpAddress());
        }
        if (this.setXForwardedForHeader()) {
            String forwardedFor = headers.get("X-Forwarded-For");
            forwardedFor = U.notEmpty((String)forwardedFor) ? forwardedFor + ", " + clientIpAddress : clientIpAddress;
            headers.put("X-Forwarded-For", forwardedFor);
        }
    }

    private void handleError(Throwable error, final Req req, final Resp resp, final ProxyMapping mapping, final int attempts, final long since) {
        if (error instanceof ConnectException || error instanceof IOException) {
            if (HttpUtils.isGetReq((Req)req) && !Msc.timedOut((long)since, (long)this.timeout())) {
                Jobs.after((long)this.retryDelay()).milliseconds(new Runnable(){

                    @Override
                    public void run() {
                        ReverseProxy.this.process(req, resp, mapping, attempts + 1, since);
                    }
                });
            } else {
                HttpIO.INSTANCE.errorAndDone(req, (Throwable)U.rte((String)"Couldn't connect to the upstream!", (Throwable)error), LogLevel.DEBUG);
            }
        } else {
            HttpIO.INSTANCE.errorAndDone(req, error, LogLevel.ERROR);
        }
    }

    @Override
    protected HttpClient createClient() {
        return HTTP.client().reuseConnections(this.reuseConnections()).keepCookies(false).maxConnTotal(this.maxConnections()).maxConnPerRoute(this.maxConnectionsPerRoute());
    }
}

