/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.setup;

import org.rapidoid.config.Conf;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.env.Env;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.impl.HttpRoutesImpl;
import org.rapidoid.ioc.IoC;
import org.rapidoid.setup.My;
import org.rapidoid.setup.Setup;
import org.rapidoid.util.Msc;

public class DefaultSetup
extends RapidoidInitializer {
    private static final String MAIN_ZONE = Msc.isPlatform() ? "platform" : "main";
    private static final String ADMIN_ZONE = Msc.isPlatform() ? "platform" : "admin";
    final Setup on;
    final Setup admin;

    DefaultSetup() {
        boolean onSameServer = Setup.appAndAdminOnSameServer();
        Customization appCustomization = new Customization("main", My.custom(), Conf.ROOT);
        Customization adminCustomization = onSameServer ? appCustomization : new Customization("admin", My.custom(), Conf.ROOT);
        HttpRoutesImpl appRoutes = new HttpRoutesImpl("main", appCustomization);
        HttpRoutesImpl adminRoutes = onSameServer ? appRoutes : new HttpRoutesImpl("admin", adminCustomization);
        this.on = new Setup("main", MAIN_ZONE, IoC.defaultContext(), Setup.MAIN_CFG, appCustomization, appRoutes);
        this.admin = new Setup("admin", ADMIN_ZONE, IoC.defaultContext(), Setup.ADMIN_CFG, adminCustomization, adminRoutes);
        Setup.instances.add(this.on);
        Setup.instances.add(this.admin);
        this.initDefaults();
    }

    void initDefaults() {
        this.admin.defaults().roles(new String[]{"administrator"});
        this.admin.onInit(new Runnable(){

            @Override
            public void run() {
                if (Env.dev()) {
                    // empty if block
                }
            }
        });
    }
}

