/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.setup;

import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigOption;
import org.rapidoid.config.ConfigOptions;
import org.rapidoid.setup.Admin;
import org.rapidoid.setup.AppBootstrap;
import org.rapidoid.setup.IGoodies;
import org.rapidoid.setup.On;
import org.rapidoid.setup.Setup;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ServiceActivator
extends RapidoidThing {
    private static final Set<String> checked = U.set();

    static void activateServices() {
        ServiceActivator.bootstrapServices(On.setup(), "app", Conf.APP);
        ServiceActivator.bootstrapServices(Admin.setup(), "admin", Conf.ADMIN);
        ServiceActivator.verifyCoverage();
    }

    private static void verifyCoverage() {
        for (ConfigOption service : ConfigOptions.SERVICES) {
            if (checked.contains(service.getName())) continue;
            throw U.rte((String)("Service activation not supported: " + service.getName()));
        }
    }

    private static void bootstrapServices(Setup setup, String setupName, Config config) {
        if (ServiceActivator.boot(setupName, config, "overview")) {
            ServiceActivator.goodies().overview(setup);
        }
        if (ServiceActivator.boot(setupName, config, "application")) {
            ServiceActivator.goodies().application(setup);
        }
        if (ServiceActivator.boot(setupName, config, "lifecycle")) {
            ServiceActivator.goodies().lifecycle(setup);
        }
        if (ServiceActivator.boot(setupName, config, "manageables")) {
            ServiceActivator.goodies().manageables(setup);
        }
        if (ServiceActivator.boot(setupName, config, "jmx")) {
            ServiceActivator.goodies().jmx(setup);
        }
        if (ServiceActivator.boot(setupName, config, "metrics")) {
            ServiceActivator.goodies().metrics(setup);
        }
        if (ServiceActivator.boot(setupName, config, "deploy")) {
            ServiceActivator.goodies().deploy(setup);
        }
        if (ServiceActivator.boot(setupName, config, "ping")) {
            ServiceActivator.goodies().ping(setup);
        }
        if (ServiceActivator.boot(setupName, config, "auth")) {
            ServiceActivator.goodies().auth(setup);
        }
        if (ServiceActivator.boot(setupName, config, "oauth")) {
            ServiceActivator.goodies().oauth(setup);
        }
        if (ServiceActivator.boot(setupName, config, "entities")) {
            ServiceActivator.goodies().entities(setup);
        }
        if (ServiceActivator.boot(setupName, config, "center")) {
            ServiceActivator.goodies().adminCenter(setup);
        }
        if (ServiceActivator.boot(setupName, config, "welcome")) {
            ServiceActivator.goodies().welcome(setup);
        }
        if (ServiceActivator.boot(setupName, config, "status")) {
            ServiceActivator.goodies().status(setup);
        }
        if (ServiceActivator.boot(setupName, config, "discovery")) {
            ServiceActivator.goodies().discovery(setup);
        }
        if (ServiceActivator.boot(setupName, config, "echo")) {
            ServiceActivator.goodies().echo(setup);
        }
    }

    private static boolean boot(String setupName, Config config, String service) {
        if (!ServiceActivator.documented(service)) {
            throw U.rte((String)("Service not documented: " + service));
        }
        checked.add(service);
        return Msc.bootService((Config)config, (String)service);
    }

    private static boolean documented(String service) {
        for (ConfigOption opt : ConfigOptions.SERVICES) {
            if (!service.equals(opt.getName())) continue;
            return true;
        }
        return false;
    }

    private static IGoodies goodies() {
        return AppBootstrap.getGoodies();
    }
}

