/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.integrate;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.rapidoid.http.View;
import org.rapidoid.http.customize.ResourceLoader;
import org.rapidoid.http.impl.AbstractViewResolver;
import org.rapidoid.u.U;

public class JMustacheViewResolver
extends AbstractViewResolver<Mustache.Compiler> {
    public View getView(String viewName, ResourceLoader resourceLoader) throws Exception {
        String filename = this.filename(viewName);
        byte[] bytes = resourceLoader.load(filename);
        if (bytes == null) {
            return null;
        }
        Mustache.TemplateLoader loader = this.loader(resourceLoader);
        String template = new String(bytes);
        Mustache.Compiler compiler = (Mustache.Compiler)this.getViewFactory(resourceLoader);
        Template mustache = compiler.withLoader(loader).compile(template);
        return this.view(mustache);
    }

    protected Mustache.Compiler createViewFactory(ResourceLoader templateLoader) {
        return Mustache.compiler().withLoader(this.loader(templateLoader));
    }

    protected Mustache.TemplateLoader loader(final ResourceLoader templateLoader) {
        return new Mustache.TemplateLoader(){

            public Reader getTemplate(String name) throws Exception {
                String filename = JMustacheViewResolver.this.filename(name);
                byte[] bytes = templateLoader.load(filename);
                U.must((bytes != null ? 1 : 0) != 0, (String)"The JMustache template '%s' doesn't exist!", (Object)filename);
                return new StringReader(new String(bytes));
            }
        };
    }

    protected View view(final Template mustache) {
        return new View(){

            public void render(Object model, OutputStream out) {
                PrintWriter writer = new PrintWriter(out);
                mustache.execute(model, (Writer)writer);
                writer.flush();
            }
        };
    }
}

