/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.integrate;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheResolver;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.rapidoid.http.View;
import org.rapidoid.http.customize.ResourceLoader;
import org.rapidoid.http.impl.AbstractViewResolver;
import org.rapidoid.u.U;

public class MustacheJavaViewResolver
extends AbstractViewResolver<DefaultMustacheFactory> {
    public View getView(String viewName, ResourceLoader resourceLoader) throws Exception {
        String filename = this.filename(viewName);
        if (resourceLoader.load(filename) == null) {
            return null;
        }
        DefaultMustacheFactory mf = (DefaultMustacheFactory)this.getViewFactory(resourceLoader);
        Mustache mustache = mf.compile(filename);
        return this.view(mustache);
    }

    protected DefaultMustacheFactory createViewFactory(ResourceLoader templateLoader) {
        return new DefaultMustacheFactory(this.mustacheResolver(templateLoader));
    }

    protected View view(final Mustache mustache) {
        return new View(){

            public void render(Object model, OutputStream out) {
                PrintWriter writer = new PrintWriter(out);
                mustache.execute((Writer)writer, model);
                writer.flush();
            }
        };
    }

    protected MustacheResolver mustacheResolver(final ResourceLoader templateLoader) {
        return new MustacheResolver(){

            public Reader getReader(String name) {
                try {
                    byte[] bytes = templateLoader.load(name);
                    U.must((bytes != null ? 1 : 0) != 0, (String)"The Mustache.java template '%s' doesn't exist!", (Object)name);
                    return new StringReader(new String(bytes));
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
        };
    }
}

