/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jpa;

import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import org.rapidoid.RapidoidThing;
import org.rapidoid.datamodel.Results;
import org.rapidoid.datamodel.impl.ResultsImpl;
import org.rapidoid.jpa.JPA;
import org.rapidoid.jpa.impl.JPACriteriaQueryEntities;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.u.U;

@Named
public class JPATool
extends RapidoidThing {
    @PersistenceContext
    private volatile EntityManager em;
    private final boolean managed;

    public JPATool() {
        this(null, true);
    }

    public JPATool(EntityManager em, boolean managed) {
        this.em = em;
        this.managed = managed;
    }

    public <E> E save(E entity) {
        Object id = this.getIdentifier(entity);
        if (id == null) {
            return this.insert(entity);
        }
        return this.update(entity);
    }

    public <E> E insert(final E entity) {
        return this.transactional(new Callable<E>(){

            @Override
            public E call() throws Exception {
                JPATool.this.em.persist(entity);
                return entity;
            }
        });
    }

    public <E> E update(final E entity) {
        U.notNull((Object)this.getIdentifier(entity), (String)"entity identifier", (Object[])new Object[0]);
        return this.transactional(new Callable<E>(){

            @Override
            public E call() throws Exception {
                if (JPATool.this.em.contains(entity)) {
                    JPATool.this.em.persist(entity);
                    return entity;
                }
                return JPATool.this.em.merge(entity);
            }
        });
    }

    public <E> E merge(final E entity) {
        return this.transactional(new Callable<E>(){

            @Override
            public E call() throws Exception {
                return JPATool.this.em.merge(entity);
            }
        });
    }

    public <E> void delete(final Class<E> clazz, final Object id) {
        this.transactional(new Callable<E>(){

            @Override
            public E call() throws Exception {
                JPATool.this.em.remove(JPATool.this.get(clazz, id));
                return null;
            }
        });
    }

    public void delete(final Object entity) {
        this.transactional(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JPATool.this.em.remove(entity);
                return null;
            }
        });
    }

    public void transactional(Runnable action) {
        this.transactional(action, false);
    }

    public void transactional(Runnable action, boolean readOnly) {
        this.transactional(Lmbd.callable((Runnable)action), readOnly);
    }

    public <E> E transactional(Callable<E> action) {
        return this.transactional(action, false);
    }

    public <E> E transactional(Callable<E> action, boolean readOnly) {
        boolean newTx;
        this.ensureNotInRollbackOnlyTransation();
        EntityTransaction tx = this.em.getTransaction();
        U.notNull((Object)tx, (String)"transaction", (Object[])new Object[0]);
        boolean bl = newTx = !tx.isActive();
        if (newTx) {
            tx.begin();
        }
        if (readOnly) {
            tx.setRollbackOnly();
        }
        try {
            E result = action.call();
            if (newTx) {
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
            return result;
        }
        catch (Throwable e) {
            if (newTx && tx.isActive()) {
                tx.rollback();
            }
            throw U.rte((String)"Transaction execution error, rolled back!", (Throwable)e);
        }
    }

    private void ensureNotInRollbackOnlyTransation() {
        EntityTransaction tx = this.em.getTransaction();
        U.must((!tx.isActive() || !tx.getRollbackOnly() ? 1 : 0) != 0, (String)"Cannot perform writes inside read-only transaction!");
    }

    public <E> E get(Class<E> clazz, Object id) {
        E entity = this.getIfExists(clazz, id);
        U.must((entity != null ? 1 : 0) != 0, (String)"Cannot find %s with ID=%s", (Object)clazz.getSimpleName(), (Object)id);
        return entity;
    }

    public <E> E reference(Class<E> clazz, Object id) {
        return (E)this.em.getReference(clazz, id);
    }

    public <T> T getIfExists(Class<T> clazz, Object id) {
        return (T)this.em.find(clazz, id);
    }

    public List<EntityType<?>> getEntityTypes() {
        return U.list((Iterable)this.em.getMetamodel().getEntities());
    }

    public <E> List<E> getAllEntities() {
        List all = U.list();
        for (EntityType<?> entityType : this.getEntityTypes()) {
            all.addAll(this.of(entityType.getJavaType()).all());
        }
        return all;
    }

    public long count(Class<?> clazz) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        cq.select((Selection)cb.count((Expression)cq.from(clazz)));
        return (Long)this.em.createQuery(cq).getSingleResult();
    }

    public void flush() {
        this.transactional(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JPATool.this.em.flush();
                return null;
            }
        });
    }

    public void refresh(Object entity) {
        this.em.refresh(entity);
    }

    public void detach(Object entity) {
        this.em.detach(entity);
    }

    public boolean isLoaded(Object entity) {
        return this.em.getEntityManagerFactory().getPersistenceUnitUtil().isLoaded(entity);
    }

    public boolean isLoaded(Object entity, String attribute) {
        return this.em.getEntityManagerFactory().getPersistenceUnitUtil().isLoaded(entity, attribute);
    }

    public Object getIdentifier(Object entity) {
        return this.em.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entity);
    }

    public <T> Results<T> find(CriteriaQuery<T> query) {
        return new ResultsImpl(new JPACriteriaQueryEntities<T>(query));
    }

    public <T> Results<T> of(Class<T> clazz) {
        CriteriaQuery query = this.cb().createQuery(clazz);
        query.from(clazz);
        return this.find(query);
    }

    private CriteriaBuilder cb() {
        return JPA.provideEmf().getCriteriaBuilder();
    }

    public void close() {
        this.em.close();
    }

    public void done() {
        if (!this.managed) {
            this.close();
        }
    }

    public EntityManager em() {
        return this.em;
    }
}

