/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.io.OutputStream;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.activity.RapidoidThreadLocals;
import org.rapidoid.render.RenderCtxImpl;
import org.rapidoid.render.Template;
import org.rapidoid.render.TemplateFactory;
import org.rapidoid.render.TemplateRenderer;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.writable.ReusableWritable;
import org.rapidoid.writable.Writable;
import org.rapidoid.writable.WritableOutputStream;

public class RapidoidTemplate
extends RapidoidThing
implements Template {
    private final String filename;
    private final TemplateRenderer template;
    private final TemplateFactory factory;

    public RapidoidTemplate(String filename, TemplateRenderer template, TemplateFactory factory) {
        this.filename = filename;
        this.template = template;
        this.factory = factory;
    }

    void doRenderMulti(RapidoidThreadLocals locals, Writable output, List<Object> model) {
        RenderCtxImpl renderCtx = this.getRenderCtx(locals);
        renderCtx.out(output).factory(this.factory).filename(this.filename).multiModel(model);
        this.template.render(renderCtx);
        renderCtx.reset();
    }

    void doRender(RapidoidThreadLocals locals, Writable output, Object model) {
        RenderCtxImpl renderCtx = this.getRenderCtx(locals);
        renderCtx.out(output).factory(this.factory).filename(this.filename).model(model);
        this.template.render(renderCtx);
        renderCtx.reset();
    }

    private RenderCtxImpl getRenderCtx(RapidoidThreadLocals locals) {
        RenderCtxImpl renderCtx = (RenderCtxImpl)locals.renderContext;
        if (renderCtx == null) {
            renderCtx = new RenderCtxImpl();
            locals.renderContext = renderCtx;
        }
        if (!renderCtx.busy()) {
            renderCtx.claim();
            return renderCtx;
        }
        return new RenderCtxImpl();
    }

    public void renderMultiModel(OutputStream output, Object ... model) {
        this.doRenderMulti(Msc.locals(), (Writable)new WritableOutputStream(output), U.list((Object[])model));
    }

    @Override
    public void renderTo(OutputStream output, Object model) {
        this.renderTo((Writable)new WritableOutputStream(output), model);
    }

    @Override
    public void renderTo(Writable output, Object model) {
        this.doRender(Msc.locals(), output, model);
    }

    @Override
    public byte[] renderToBytes(Object model) {
        RapidoidThreadLocals locals = Msc.locals();
        ReusableWritable out = locals.templateRenderingOutput();
        this.doRender(locals, (Writable)out, model);
        return out.copy();
    }

    @Override
    public String render(Object model) {
        return new String(this.renderToBytes(model));
    }

    public void renderInContext(RenderCtxImpl renderCtx) {
        this.template.render(renderCtx);
    }
}

