/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.dbadmin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.rapidoid.collection.Coll;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.dbadmin.ManageableTable;
import org.rapidoid.group.AbstractManageable;
import org.rapidoid.group.Manageable;
import org.rapidoid.group.ManageableBean;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.lambda.Operation;
import org.rapidoid.u.U;

@ManageableBean(kind="database")
public class ManageableDatabase
extends AbstractManageable {
    private final JdbcClient jdbc;
    private final String name;
    public final List<ManageableTable> tables = Coll.synchronizedList((Object[])new ManageableTable[0]);

    public ManageableDatabase(JdbcClient jdbc, String name) {
        this.jdbc = jdbc;
        this.name = name;
    }

    public String id() {
        return this.name;
    }

    public Map<String, List<Manageable>> getManageableChildren() {
        return U.map((Object[])new Object[]{"tables", this.tables});
    }

    protected void doReloadManageable(Callback<Void> callback) {
        this.jdbc.execute(callback, (Operation)new Operation<Connection>(){

            public void execute(Connection conn) throws SQLException {
                ManageableDatabase.this.reload(conn);
            }
        });
    }

    private synchronized void reload(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet tablesRS = meta.getTables(this.name, null, null, null);
        this.tables.clear();
        while (tablesRS.next()) {
            String tableName = tablesRS.getString("TABLE_NAME");
            ManageableTable table = new ManageableTable(this.jdbc, this.name, tableName);
            table.remarks = tablesRS.getString("REMARKS");
            table.tableType = tablesRS.getString("TABLE_TYPE");
            this.tables.add(table);
        }
    }
}

