/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.dbadmin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.rapidoid.collection.Coll;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.dbadmin.ManageableDatabase;
import org.rapidoid.group.AutoManageable;
import org.rapidoid.group.Manageable;
import org.rapidoid.group.ManageableBean;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.lambda.Operation;
import org.rapidoid.u.U;

@ManageableBean(kind="rdbms")
public class ManageableRdbms
extends AutoManageable<JdbcClient> {
    private final JdbcClient jdbc;
    public String name;
    public String version;
    public final List<ManageableDatabase> databases = Coll.synchronizedList((Object[])new ManageableDatabase[0]);

    public ManageableRdbms(JdbcClient jdbc) {
        super(jdbc.id());
        this.jdbc = jdbc;
    }

    public Map<String, List<Manageable>> getManageableChildren() {
        return U.map((Object[])new Object[]{"databases", this.databases});
    }

    protected void doReloadManageable(Callback<Void> callback) {
        this.jdbc.execute(callback, (Operation)new Operation<Connection>(){

            public void execute(Connection conn) throws SQLException {
                ManageableRdbms.this.reload(conn);
            }
        });
    }

    private synchronized void reload(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        this.name = meta.getDatabaseProductName();
        this.version = meta.getDatabaseProductVersion();
        ResultSet schemas = meta.getCatalogs();
        this.databases.clear();
        while (schemas.next()) {
            String name = schemas.getString("TABLE_CAT");
            ManageableDatabase schema = new ManageableDatabase(this.jdbc, name);
            this.databases.add(schema);
        }
    }
}

