/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.goodies;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.rapidoid.group.GroupOf;
import org.rapidoid.group.Groups;
import org.rapidoid.group.Manageable;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.Grid;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ManageablesOverviewPage
extends GUI
implements Callable<Object> {
    private volatile Collection<? extends GroupOf<?>> groups;
    private volatile Class<? extends Manageable> groupType;
    private volatile String baseUri;

    @Override
    public Object call() throws Exception {
        List info = U.list();
        Collection<GroupOf<?>> targetGroups = this.retrieveTargetGroups();
        for (GroupOf<?> group : targetGroups) {
            List items = group.items();
            List nav = U.list((Object[])new String[]{group.kind()});
            info.add(ManageablesOverviewPage.h2((Object[])new Object[]{group.kind()}));
            ManageablesOverviewPage.addInfo(this.baseUri, info, nav, items);
        }
        info.add(ManageablesOverviewPage.autoRefresh((long)2000L));
        return ManageablesOverviewPage.multi((Object[])new Object[]{info});
    }

    private Collection<? extends GroupOf<?>> retrieveTargetGroups() {
        if (this.groups != null) {
            return this.groups;
        }
        if (this.groupType != null) {
            return Groups.find(this.groupType);
        }
        return Groups.all();
    }

    public static void addInfo(String baseUri, List<Object> info, List<String> nav, List<? extends Manageable> items) {
        List columns;
        if (U.notEmpty(items) && U.notEmpty((Collection)(columns = U.list((Iterable)((Manageable)U.first(items)).getManageableProperties())))) {
            ManageablesOverviewPage.addInfo(baseUri, info, nav, items, columns);
        }
    }

    protected static void addInfo(final String baseUri, List<Object> info, final List<String> nav, List<? extends Manageable> items, List<String> columns) {
        columns.add("(Actions)");
        for (Manageable manageable : items) {
            manageable.reloadManageable();
        }
        Grid grid = ManageablesOverviewPage.grid(items).columns(columns).headers(columns).toUri((Mapper)new Mapper<Manageable, String>(){

            public String map(Manageable item) throws Exception {
                List uri = U.list((Iterable)nav);
                uri.add(0, U.safe((String)baseUri));
                uri.add(item.id());
                return Msc.uri((String[])((String[])U.arrayOf((Iterable)uri)));
            }
        }).pageSize(100);
        info.add(grid);
    }

    public Collection<? extends GroupOf<?>> groups() {
        return this.groups;
    }

    public ManageablesOverviewPage groups(Collection<? extends GroupOf<?>> groups) {
        this.groups = groups;
        return this;
    }

    public String baseUri() {
        return this.baseUri;
    }

    public ManageablesOverviewPage baseUri(String baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public Class<? extends Manageable> groupType() {
        return this.groupType;
    }

    public ManageablesOverviewPage groupType(Class<? extends Manageable> groupType) {
        this.groupType = groupType;
        return this;
    }
}

