/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.web.config.listener;

import org.rapidoid.http.HttpVerb;
import org.rapidoid.http.MediaType;
import org.rapidoid.setup.App;
import org.rapidoid.setup.OnRoute;
import org.rapidoid.u.U;
import org.rapidoid.web.config.bean.AbstractRouteConfig;
import org.rapidoid.web.config.listener.GenericConfigListener;

public abstract class GenericRouteConfigListener<T extends AbstractRouteConfig>
extends GenericConfigListener<T> {
    public GenericRouteConfigListener(Class<T> type) {
        super(type);
    }

    @Override
    protected void applyEntry(String key, T config) {
        String uri;
        HttpVerb verb;
        String[] verbUri = key.split("\\s+");
        if (verbUri.length == 1) {
            verb = null;
            uri = verbUri[0];
        } else if (verbUri.length == 2) {
            verb = HttpVerb.from((String)verbUri[0]);
            uri = verbUri[1];
        } else {
            throw U.rte((String)"Invalid route!");
        }
        this.addRoute(config, verb, uri);
    }

    private void addRoute(T config, HttpVerb verb, String uri) {
        OnRoute route = this.addRoute(verb, uri);
        if (((AbstractRouteConfig)((Object)config)).contentType != null) {
            route.contentType(MediaType.of((String)((AbstractRouteConfig)((Object)config)).contentType));
        }
        if (((AbstractRouteConfig)((Object)config)).managed != null) {
            route.managed(((AbstractRouteConfig)((Object)config)).managed.booleanValue());
        }
        if (((AbstractRouteConfig)((Object)config)).transaction != null) {
            route.transaction(((AbstractRouteConfig)((Object)config)).transaction);
        }
        if (((AbstractRouteConfig)((Object)config)).cacheTTL != null) {
            route.cacheTTL(((AbstractRouteConfig)((Object)config)).cacheTTL.longValue());
        }
        if (((AbstractRouteConfig)((Object)config)).cacheCapacity != null) {
            route.cacheCapacity(((AbstractRouteConfig)((Object)config)).cacheCapacity.intValue());
        }
        if (((AbstractRouteConfig)((Object)config)).roles != null) {
            route.roles(((AbstractRouteConfig)((Object)config)).roles);
            App.boot().auth();
        }
        this.addHandler(config, uri, route);
    }

    protected abstract OnRoute addRoute(HttpVerb var1, String var2);

    protected abstract void addHandler(T var1, String var2, OnRoute var3);
}

