/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.web.config.listener;

import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.ConfigChanges;
import org.rapidoid.lambda.Operation;
import org.rapidoid.reverseproxy.Reverse;
import org.rapidoid.reverseproxy.ReverseProxyMapDSL;
import org.rapidoid.setup.App;
import org.rapidoid.web.config.bean.ProxyConfig;

public class ProxyConfigListener
extends RapidoidThing
implements Operation<ConfigChanges> {
    public void execute(ConfigChanges changes) throws Exception {
        for (Map.Entry e : changes.getAddedOrChangedAs(ProxyConfig.class).entrySet()) {
            String uri = ((String)e.getKey()).trim();
            ProxyConfig proxy = (ProxyConfig)((Object)e.getValue());
            this.applyProxyEntry(uri, proxy);
        }
    }

    private void applyProxyEntry(String uri, ProxyConfig config) {
        ReverseProxyMapDSL proxy = Reverse.proxy((String)uri);
        if (config.upstreams != null) {
            proxy.to(config.upstreams);
        }
        if (config.cacheTTL != null) {
            proxy.cacheTTL(config.cacheTTL.longValue());
        }
        if (config.cacheCapacity != null) {
            proxy.cacheCapacity(config.cacheCapacity.intValue());
        }
        if (config.roles != null) {
            proxy.roles(config.roles);
            App.boot().auth();
        }
        proxy.add();
    }
}

