/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.web.handler;

import java.util.Map;
import java.util.regex.Pattern;
import org.rapidoid.commons.Err;
import org.rapidoid.datamodel.Results;
import org.rapidoid.datamodel.impl.NoResults;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.Grid;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.render.Render;
import org.rapidoid.u.U;
import org.rapidoid.web.config.bean.GuiConfig;
import org.rapidoid.web.config.bean.PageConfig;
import org.rapidoid.web.config.bean.PageGuiConfig;
import org.rapidoid.web.handler.GenericHandler;

public class PageHandler
extends GenericHandler {
    private final PageConfig page;

    public PageHandler(PageConfig page) {
        this.page = page;
    }

    public Object execute(Req req, Resp resp) {
        if (U.notEmpty((String)this.page.sql)) {
            return this.gui(this.page);
        }
        if (U.notEmpty(this.page.gui)) {
            return this.guiModel(this.page.gui);
        }
        return GUI.N_A;
    }

    private Object guiModel(Map<String, PageGuiConfig> gui) {
        Map model = U.map();
        for (Map.Entry<String, PageGuiConfig> e : gui.entrySet()) {
            PageGuiConfig cfg = e.getValue();
            Object data = this.fetchData(cfg);
            Object widget = this.createWidget(cfg, data);
            model.put(e.getKey() + "_data", data);
            model.put(e.getKey(), widget);
        }
        return model;
    }

    private Object fetchData(GuiConfig gui) {
        if (U.notEmpty((String)gui.sql())) {
            if (gui.single()) {
                return this.sqlItems(gui.sql()).single();
            }
            return this.sqlItems(gui.sql());
        }
        return new NoResults();
    }

    private Object gui(GuiConfig gui) {
        Object data = this.fetchData(gui);
        return this.createWidget(gui, data);
    }

    private Object createWidget(GuiConfig gui, Object data) {
        Object item = this.createWidgetByType(gui, data);
        item = this.wrapWidget(gui, item);
        return item;
    }

    private Object wrapWidget(GuiConfig gui, Object item) {
        if (U.notEmpty((String)gui.caption())) {
            item = GUI.multi((Object[])new Object[]{GUI.titleBox((Object[])new Object[]{gui.caption()}), item});
        }
        if (U.notEmpty((String)gui.header()) || U.notEmpty((String)gui.footer())) {
            item = GUI.panel((Object[])new Object[]{item}).header((Object)gui.header()).footer((Object)gui.footer());
        }
        return item;
    }

    private Object createWidgetByType(GuiConfig gui, Object data) {
        switch (gui.type()) {
            case grid: {
                if (gui.single()) {
                    return GUI.details((Object)data);
                }
                Grid grid = this.grid(gui, (Results)data);
                if (gui.pageSize() > 0) {
                    grid.pageSize(gui.pageSize());
                }
                return grid;
            }
        }
        throw Err.notReady();
    }

    public Grid grid(final GuiConfig gui, Results items) {
        String pageSize;
        String highlight;
        Req req = this.req();
        Grid grid = GUI.grid((Iterable)items);
        String q = req.param("find", null);
        if (q != null) {
            grid.highlightRegex(Pattern.quote(q));
        }
        if ((highlight = req.param("$highlight", null)) != null) {
            grid.highlightRegex(Pattern.quote(highlight));
        }
        if ((pageSize = req.param("$pageSize", null)) != null) {
            grid.pageSize(U.num((String)pageSize));
        }
        if (U.notEmpty((String)gui.uri())) {
            grid.toUri((Mapper)new Mapper<Object, String>(){

                public String map(Object item) throws Exception {
                    return Render.template((String)gui.uri()).model(item);
                }
            });
        }
        return grid;
    }
}

