/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.buffer;

import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import org.rapidoid.pool.Pool;
import org.rapidoid.pool.Pools;
import org.rapidoidx.buffer.Buf;
import org.rapidoidx.buffer.MultiBuf;
import org.rapidoidx.buffer.SynchronizedBuf;

public class BufGroup {
    private final int factor;
    private final int capacity;
    private final Pool<ByteBuffer> pool;
    private final boolean synchronizedBuffers;

    public BufGroup(int factor, boolean synchronizedBuffers) {
        this.synchronizedBuffers = synchronizedBuffers;
        this.factor = factor;
        this.capacity = (int)Math.pow(2.0, factor);
        this.pool = Pools.create((String)"buffers", (Callable)new Callable<ByteBuffer>(){

            @Override
            public ByteBuffer call() {
                return ByteBuffer.allocateDirect(BufGroup.this.capacity);
            }
        }, (int)1000);
    }

    public BufGroup(int factor) {
        this(factor, false);
    }

    public Buf newBuf(String name) {
        Buf buf = new MultiBuf(this.pool, this.factor, name);
        if (this.synchronizedBuffers) {
            buf = new SynchronizedBuf(buf);
        }
        return buf;
    }

    public Buf newBuf() {
        return this.newBuf("no-name");
    }

    public Buf from(String s, String name) {
        return this.from(ByteBuffer.wrap(s.getBytes()), name);
    }

    public Buf from(ByteBuffer bbuf, String name) {
        Buf buf = this.newBuf(name);
        buf.append(bbuf);
        return buf;
    }

    public int instances() {
        return this.pool.objectsCreated();
    }
}

