/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.buffer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.rapidoid.arr.Arr;
import org.rapidoid.pool.Pool;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.D;
import org.rapidoid.wrap.LongWrap;
import org.rapidoidx.buffer.Buf;
import org.rapidoidx.buffer.BufBytes;
import org.rapidoidx.bytes.ByteBufferBytes;
import org.rapidoidx.bytes.Bytes;
import org.rapidoidx.bytes.BytesUtil;
import org.rapidoidx.data.Range;
import org.rapidoidx.data.Ranges;

public class MultiBuf
implements Buf,
Constants {
    private final byte[] HELPER = new byte[20];
    private final Range HELPER_RANGE = new Range();
    private static final int TO_BYTES = 1;
    private static final int TO_CHANNEL = 2;
    private static final int TO_BUFFER = 3;
    private final Pool<ByteBuffer> bufPool;
    private final long factor;
    private final long addrMask;
    private final int singleCap;
    private ByteBuffer[] bufs = new ByteBuffer[10];
    private int bufN;
    private long shrinkN;
    private final String name;
    private long _position;
    private long _limit;
    private long _checkpoint;
    private OutputStream outputStream;
    private final ByteBufferBytes singleBytes = new ByteBufferBytes();
    private final Bytes multiBytes;
    private Bytes _bytes = this.multiBytes = new BufBytes(this);
    private long _size;
    private boolean readOnly = false;

    public MultiBuf(Pool<ByteBuffer> bufPool, int factor, String name) {
        this.bufPool = bufPool;
        this.name = name;
        this.singleCap = (int)Math.pow(2.0, factor);
        this.factor = factor;
        this.addrMask = this.addrMask();
        assert (this.invariant(true));
    }

    private long addrMask() {
        long mask = 1L;
        for (long i = 0L; i < this.factor - 1L; ++i) {
            mask <<= 1;
            mask |= 1L;
        }
        return mask;
    }

    @Override
    public boolean isSingle() {
        assert (this.invariant(false));
        return this.bufN == 1;
    }

    @Override
    public byte get(long position) {
        assert (this.invariant(false));
        assert (position >= 0L);
        this.validatePos(position, 1L);
        ByteBuffer buf = this.bufs[(int)((position += this.shrinkN) >> (int)this.factor)];
        assert (buf != null);
        assert (this.invariant(false));
        return buf.get((int)(position & this.addrMask));
    }

    private void validatePos(long pos, long space) {
        boolean hasEnough;
        if (pos < 0L) {
            throw U.rte((String)("Invalid position: " + pos));
        }
        long least = pos + space;
        boolean bl = hasEnough = least <= this._size() && least <= this._limit;
        if (!hasEnough) {
            throw INCOMPLETE_READ;
        }
    }

    @Override
    public void put(long position, byte value) {
        assert (this.invariant(true));
        assert (position >= 0L);
        this.validatePos(position, 1L);
        ByteBuffer buf = this.bufs[(int)((position += this.shrinkN) >> (int)this.factor)];
        assert (buf != null);
        buf.put((int)(position & this.addrMask), value);
        assert (this.invariant(true));
    }

    @Override
    public long size() {
        assert (this.invariant(false));
        assert (this._size == this._size());
        return this._size;
    }

    private long _size() {
        if (this.bufN > 0) {
            long s = this.bufN - 1;
            s *= (long)this.singleCap;
            s += (long)this.bufs[this.bufN - 1].position();
            return s -= this.shrinkN;
        }
        return 0L;
    }

    private void expandUnit() {
        if (this.bufN == this.bufs.length) {
            this.bufs = (ByteBuffer[])Arr.expand((Object[])this.bufs, (int)2);
        }
        this.bufs[this.bufN] = (ByteBuffer)this.bufPool.get();
        this.bufs[this.bufN].clear();
        ++this.bufN;
    }

    @Override
    public void append(byte value) {
        assert (this.invariant(true));
        this.writableBuf().put(value);
        this.sizeChanged();
        assert (this.invariant(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(ReadableByteChannel channel) throws IOException {
        assert (this.invariant(true));
        long totalRead = 0L;
        try {
            long space;
            long read;
            boolean done;
            do {
                ByteBuffer dest = this.writableBuf();
                space = dest.remaining();
                assert (space > 0L);
                read = channel.read(dest);
                if (read >= 0L) {
                    totalRead += read;
                    continue;
                }
                this.removeLastBufferIfEmpty();
                this.sizeChanged();
                assert (this.invariant(true));
                long l = -1L;
                return l;
            } while (!(done = read < space));
        }
        finally {
            this.removeLastBufferIfEmpty();
            this.sizeChanged();
            assert (this.invariant(true));
        }
        return totalRead;
    }

    @Override
    public void append(ByteBuffer src) {
        assert (this.invariant(true));
        int theLimit = src.limit();
        while (src.hasRemaining()) {
            ByteBuffer dest = this.writableBuf();
            int space = dest.remaining();
            assert (space > 0);
            if (src.remaining() > space) {
                src.limit(src.position() + space);
            }
            dest.put(src);
            src.limit(theLimit);
        }
        this.sizeChanged();
        assert (this.invariant(true));
    }

    @Override
    public void append(byte[] src, int offset, int length) {
        assert (this.invariant(true));
        long sizeBefore = this._size();
        if (length > 0) {
            ByteBuffer buf = this.writableBuf();
            if (length <= buf.remaining()) {
                buf.put(src, offset, length);
            } else {
                int partLen = buf.remaining();
                buf.put(src, offset, partLen);
                assert (buf.remaining() == 0);
                this.append(src, offset + partLen, length - partLen);
            }
        }
        this.sizeChanged();
        assert (this._size() - sizeBefore == (long)length);
        assert (this.invariant(true));
    }

    private ByteBuffer writableBuf() {
        if (this.bufN == 0) {
            this.expandUnit();
            return this.last();
        }
        ByteBuffer cbuf = this.last();
        if (!cbuf.hasRemaining()) {
            this.expandUnit();
            cbuf = this.last();
        }
        assert (cbuf.hasRemaining());
        return cbuf;
    }

    private ByteBuffer last() {
        assert (this.bufN > 0);
        return this.bufs[this.bufN - 1];
    }

    @Override
    public ByteBuffer first() {
        assert (this.invariant(false));
        assert (this.bufN > 0);
        return this.bufs[0];
    }

    @Override
    public ByteBuffer bufAt(int index) {
        assert (this.invariant(false));
        assert (this.bufN > index);
        return this.bufs[index];
    }

    @Override
    public long append(String s) {
        assert (this.invariant(true));
        byte[] bytes = s.getBytes();
        this.append(bytes);
        this.sizeChanged();
        assert (this.invariant(true));
        return bytes.length;
    }

    public String toString() {
        return String.format("Buf " + this.name + " [size=" + this._size() + ", units=" + this.unitCount() + ", trash=" + this.shrinkN + ", pos=" + this.position() + ", limit=" + this.limit() + "] " + super.toString(), new Object[0]);
    }

    @Override
    public String data() {
        assert (this.invariant(false));
        byte[] bytes = new byte[(int)this._size()];
        long total = this.readAll(bytes, 0L, 0L, bytes.length);
        assert (total == (long)bytes.length);
        assert (this.invariant(false));
        return new String(bytes);
    }

    @Override
    public byte[] getBytes(Range range) {
        assert (this.invariant(false));
        if (range.isEmpty()) {
            return new byte[0];
        }
        byte[] bytes = new byte[(int)range.length];
        long total = this.readAll(bytes, 0L, range.start, range.length);
        assert (total == (long)bytes.length);
        assert (this.invariant(false));
        return bytes;
    }

    @Override
    public String get(Range range) {
        assert (this.invariant(false));
        byte[] bytes = this.getBytes(range);
        assert (this.invariant(false));
        return new String(bytes);
    }

    @Override
    public void get(Range range, byte[] dest, int offset) {
        assert (this.invariant(false));
        long total = this.readAll(dest, offset, range.start, range.length);
        assert (total == range.length);
        assert (this.invariant(false));
    }

    private long writeToHelper(Range range) {
        assert (this.invariant(false));
        return this.readAll(this.HELPER, 0L, range.start, range.length);
    }

    private long readAll(byte[] bytes, long destOffset, long offset, long length) {
        long wrote;
        assert (this.invariant(false));
        if (offset + length > this._size()) {
            throw new IllegalArgumentException("offset + length > buffer size!");
        }
        try {
            wrote = this.writeTo(1, offset, length, bytes, null, null, destOffset);
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        assert (this.invariant(false));
        return wrote;
    }

    @Override
    public long writeTo(WritableByteChannel channel) throws IOException {
        assert (this.invariant(true));
        long wrote = this.writeTo(2, 0L, this._size(), null, channel, null, 0L);
        assert (U.must((wrote <= this._size() ? 1 : 0) != 0, (String)"Incorrect write to channel!"));
        assert (this.invariant(true));
        return wrote;
    }

    @Override
    public long writeTo(ByteBuffer buffer) {
        assert (this.invariant(true));
        try {
            long wrote = this.writeTo(3, 0L, this._size(), null, null, buffer, 0L);
            assert (wrote == this._size());
            assert (this.invariant(true));
            return wrote;
        }
        catch (IOException e) {
            assert (this.invariant(true));
            throw U.rte((Throwable)e);
        }
    }

    private long writeTo(int mode, long offset, long length, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, long destOffset) throws IOException {
        if (this._size() == 0L) {
            assert (length == 0L);
            return 0L;
        }
        long fromPos = offset + this.shrinkN;
        long toPos = fromPos + length - 1L;
        int fromInd = (int)(fromPos >> (int)this.factor);
        int toInd = (int)(toPos >> (int)this.factor);
        int fromAddr = (int)(fromPos & this.addrMask);
        int toAddr = (int)(toPos & this.addrMask);
        assert (fromInd <= toInd);
        if (fromInd == toInd) {
            return this.writePart(this.bufs[fromInd], fromAddr, toAddr + 1, mode, bytes, channel, buffer, destOffset, -1L);
        }
        return this.multiWriteTo(mode, fromInd, toInd, fromAddr, toAddr, bytes, channel, buffer, destOffset);
    }

    private long multiWriteTo(int mode, int fromIndex, int toIndex, int fromAddr, int toAddr, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, long destOffset) throws IOException {
        ByteBuffer first = this.bufs[fromIndex];
        long len = this.singleCap - fromAddr;
        long wrote = this.writePart(first, fromAddr, this.singleCap, mode, bytes, channel, buffer, destOffset, len);
        if (wrote < len) {
            return wrote;
        }
        long wroteTotal = wrote;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            wrote = this.writePart(this.bufs[i], 0, this.singleCap, mode, bytes, channel, buffer, destOffset + wroteTotal, this.singleCap);
            wroteTotal += wrote;
            if (wrote >= (long)this.singleCap) continue;
            return wroteTotal;
        }
        ByteBuffer last = this.bufs[toIndex];
        wroteTotal += this.writePart(last, 0, toAddr + 1, mode, bytes, channel, buffer, destOffset + wroteTotal, toAddr + 1);
        return wroteTotal;
    }

    private long writePart(ByteBuffer src, int pos, int limit, int mode, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, long destOffset, long len) throws IOException {
        long count;
        int posBackup = src.position();
        int limitBackup = src.limit();
        src.position(pos);
        src.limit(limit);
        assert ((long)src.remaining() == len || len < 0L);
        block0 : switch (mode) {
            case 1: {
                if (len >= 0L) {
                    src.get(bytes, (int)destOffset, (int)len);
                    count = len;
                    break;
                }
                count = src.remaining();
                src.get(bytes, (int)destOffset, (int)count);
                break;
            }
            case 2: {
                count = 0L;
                while (src.hasRemaining()) {
                    long wrote = channel.write(src);
                    count += wrote;
                    if (wrote != 0L) continue;
                    break block0;
                }
                break;
            }
            case 3: {
                count = src.remaining();
                buffer.put(src);
                break;
            }
            default: {
                throw U.notExpected();
            }
        }
        src.limit(limitBackup);
        src.position(posBackup);
        return count;
    }

    private boolean invariant(boolean writing) {
        if (this.readOnly) assert (!writing);
        try {
            assert (this.bufN >= 0);
            for (int i = 0; i < this.bufN - 1; ++i) {
                ByteBuffer buf = this.bufs[i];
                assert (buf.position() == this.singleCap);
                assert (buf.limit() == this.singleCap);
                assert (buf.capacity() == this.singleCap);
            }
            if (this.bufN > 0) {
                ByteBuffer buf = this.bufs[this.bufN - 1];
                assert (buf == this.last());
                assert (buf.position() > 0);
                assert (buf.capacity() == this.singleCap);
            }
            return true;
        }
        catch (AssertionError e) {
            this.dumpBuffers();
            throw e;
        }
    }

    private void dumpBuffers() {
        System.out.println(">> BUFFER " + this.name + " HAS " + this.bufN + " PARTS:");
        for (int i = 0; i < this.bufN - 1; ++i) {
            ByteBuffer buf = this.bufs[i];
            D.print((Object[])new Object[]{i + "]" + buf});
        }
        if (this.bufN > 0) {
            ByteBuffer buf = this.bufs[this.bufN - 1];
            D.print((Object[])new Object[]{"LAST]" + buf});
        }
    }

    @Override
    public void deleteBefore(long count) {
        assert (this.invariant(true));
        if (count == this._size()) {
            this.clear();
            return;
        }
        this.shrinkN += count;
        while (this.shrinkN >= (long)this.singleCap) {
            this.removeFirstBuf();
            this.shrinkN -= (long)this.singleCap;
        }
        this._position -= count;
        if (this._position < 0L) {
            this._position = 0L;
        }
        this.sizeChanged();
        assert (this.invariant(true));
    }

    private void removeFirstBuf() {
        this.bufs[0].clear();
        this.bufPool.release((Object)this.bufs[0]);
        for (int i = 0; i < this.bufN - 1; ++i) {
            this.bufs[i] = this.bufs[i + 1];
        }
        --this.bufN;
    }

    private void removeLastBuf() {
        this.bufs[this.bufN - 1].clear();
        this.bufPool.release((Object)this.bufs[this.bufN - 1]);
        --this.bufN;
        if (this.bufN == 0) {
            this.shrinkN = 0L;
        }
    }

    private void removeLastBufferIfEmpty() {
        if (this.bufN > 0 && this.last().position() == 0) {
            this.removeLastBuf();
        }
    }

    @Override
    public int unitCount() {
        assert (this.invariant(false));
        return this.bufN;
    }

    @Override
    public int unitSize() {
        assert (this.invariant(false));
        return this.singleCap;
    }

    @Override
    public void put(long position, byte[] bytes, int offset, int length) {
        assert (this.invariant(true));
        long pos = position;
        for (int i = offset; i < offset + length; ++i) {
            this.put(pos++, bytes[i]);
        }
        assert (this.invariant(true));
    }

    @Override
    public void append(byte[] bytes) {
        assert (this.invariant(true));
        this.append(bytes, 0, bytes.length);
        assert (this.invariant(true));
    }

    @Override
    public void deleteAfter(long position) {
        assert (this.invariant(true));
        if (this.bufN == 0 || position == this._size()) {
            assert (this.invariant(true));
            return;
        }
        assert (this.validPosition(position));
        if (this.bufN == 1) {
            long newPos = position + this.shrinkN;
            assert (newPos <= Integer.MAX_VALUE && newPos <= (long)this.singleCap);
            this.first().position((int)newPos);
            if (newPos == 0L) {
                this.removeLastBuf();
            }
        } else {
            int index = (int)((position += this.shrinkN) >> (int)this.factor);
            int addr = (int)(position & this.addrMask);
            while (index < this.bufN - 1) {
                this.removeLastBuf();
            }
            ByteBuffer last = this.bufs[index];
            assert (this.last() == last);
            if (addr > 0) {
                last.position(addr);
            } else {
                this.removeLastBuf();
                if (this.bufN > 0) {
                    this.last().position(this.singleCap);
                }
            }
        }
        this.removeLastBufferIfEmpty();
        this.sizeChanged();
        assert (this.invariant(true));
    }

    @Override
    public void deleteLast(long count) {
        assert (this.invariant(true));
        this.deleteAfter(this._size() - count);
        assert (this.invariant(true));
    }

    private boolean validPosition(long position) {
        assert (U.must((position >= 0L && position < this._size() ? 1 : 0) != 0, (String)"Invalid position: %s", (long)position));
        return true;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.bufN; ++i) {
            this.bufs[i].clear();
            this.bufPool.release((Object)this.bufs[i]);
        }
        this.readOnly = false;
        this.shrinkN = 0L;
        this.bufN = 0;
        this._position = 0L;
        this.sizeChanged();
        assert (this.invariant(true));
    }

    @Override
    public long getN(Range range) {
        int start;
        assert (this.invariant(false));
        assert (range.length >= 1L);
        if (range.length > 20L) {
            assert (this.invariant(false));
            throw U.rte((String)"Too many digits!");
        }
        long count = this.writeToHelper(range);
        long value = 0L;
        boolean negative = this.HELPER[0] == 45;
        int i = start = negative ? 1 : 0;
        while ((long)i < count) {
            byte b = this.HELPER[i];
            if (b < 48 || b > 57) {
                assert (this.invariant(false));
                throw U.rte((String)"Invalid number: '%s'", (Object[])new Object[]{this.get(range)});
            }
            long digit = b - 48;
            value = value * 10L + digit;
            ++i;
        }
        assert (this.invariant(false));
        return negative ? -value : value;
    }

    @Override
    public ByteBuffer getSingle() {
        assert (this.invariant(false));
        return this.isSingle() ? this.first() : null;
    }

    @Override
    public long putNumAsText(long position, long n, boolean forward) {
        long space;
        long direction;
        assert (this.invariant(true));
        long l = direction = forward ? 0L : -1L;
        if (n >= 0L) {
            if (n < 10L) {
                this.put(position, (byte)(n + 48L));
                space = 1L;
            } else if (n < 100L) {
                long dig1 = n / 10L;
                long dig2 = n % 10L;
                this.put(position + direction, (byte)(dig1 + 48L));
                this.put(position + direction + 1L, (byte)(dig2 + 48L));
                space = 2L;
            } else {
                long digitsN = (long)Math.ceil(Math.log10(n + 1L));
                long pos = position + digitsN - 1L + direction * digitsN;
                if (!forward) {
                    ++pos;
                }
                while (true) {
                    long digit = n % 10L;
                    byte dig = (byte)(digit + 48L);
                    this.put(pos--, dig);
                    if (n < 10L) break;
                    n /= 10L;
                }
                space = digitsN;
            }
        } else if (forward) {
            this.put(position, (byte)45);
            space = this.putNumAsText(position + 1L, -n, forward) + 1L;
        } else {
            long digits = this.putNumAsText(position, -n, forward);
            this.put(position - digits, (byte)45);
            space = digits + 1L;
        }
        assert (this.invariant(true));
        return space;
    }

    private long rebase(long pos, long bufInd) {
        return (bufInd << (int)this.factor) + pos - this.shrinkN;
    }

    @Override
    public byte next() {
        assert (this.invariant(false));
        byte b = this.get(this._position++);
        assert (this.invariant(false));
        return b;
    }

    @Override
    public void back(long count) {
        assert (this.invariant(false));
        --this._position;
        assert (this.invariant(false));
    }

    @Override
    public byte peek() {
        assert (this.invariant(false));
        byte b = this.get(this._position);
        assert (this.invariant(false));
        return b;
    }

    @Override
    public boolean hasRemaining() {
        boolean result;
        assert (this.invariant(false));
        boolean bl = result = this.remaining() > 0L;
        assert (this.invariant(false));
        return result;
    }

    @Override
    public long remaining() {
        assert (this.invariant(false));
        return this._limit - this._position;
    }

    @Override
    public long position() {
        assert (this.invariant(false));
        return this._position;
    }

    @Override
    public long limit() {
        assert (this.invariant(false));
        return this._limit;
    }

    private void sizeChanged() {
        this._size = this._size();
        this._limit = this._size();
        if (this.bufN == 1) {
            this.singleBytes.setBuf(this.bufs[0]);
            this._bytes = this.singleBytes;
        } else {
            this._bytes = this.multiBytes;
        }
    }

    @Override
    public void position(long position) {
        assert (this.invariant(false));
        this._position = position;
        assert (this.invariant(false));
    }

    @Override
    public void limit(long limit) {
        assert (this.invariant(false));
        this._limit = limit;
        assert (this.invariant(false));
    }

    @Override
    public void upto(byte value, Range range) {
        assert (this.invariant(false));
        range.starts(this._position);
        while (this.get(this._position) != value) {
            ++this._position;
        }
        range.ends(this._position);
        ++this._position;
        assert (this.invariant(false));
    }

    @Override
    public ByteBuffer exposed() {
        assert (this.invariant(false));
        ByteBuffer first = this.first();
        assert (this.invariant(false));
        return first;
    }

    @Override
    public void scanUntil(byte value, Range range) {
        byte b;
        int pos;
        assert (this.invariant(false));
        this.requireRemaining(1L);
        long start = this.position();
        long limit = this.limit();
        long last = limit - 1L;
        long fromPos = start + this.shrinkN;
        long toPos = last + this.shrinkN;
        int fromInd = (int)(fromPos >> (int)this.factor);
        int toInd = (int)(toPos >> (int)this.factor);
        int fromAddr = (int)(fromPos & this.addrMask);
        int toAddr = (int)(toPos & this.addrMask);
        assert (U.must((fromInd >= 0 ? 1 : 0) != 0, (String)"bad start: %s", (long)start));
        assert (U.must((toInd >= 0 ? 1 : 0) != 0, (String)"bad end: %s", (long)last));
        ByteBuffer src = this.bufs[fromInd];
        long absPos = start;
        for (pos = fromAddr; pos < this.singleCap; ++pos) {
            b = src.get(pos);
            if (b == value) {
                range.setInterval(start, absPos);
                this.position(absPos + 1L);
                assert (this.invariant(false));
                return;
            }
            ++absPos;
        }
        for (int i = fromInd + 1; i < toInd; ++i) {
            src = this.bufs[i];
            for (int pos2 = 0; pos2 < this.singleCap; ++pos2) {
                byte b2 = src.get(pos2);
                if (b2 == value) {
                    range.setInterval(start, absPos);
                    this.position(absPos + 1L);
                    assert (this.invariant(false));
                    return;
                }
                ++absPos;
            }
        }
        if (fromInd < toInd) {
            src = this.bufs[toInd];
            for (pos = 0; pos <= toAddr; ++pos) {
                b = src.get(pos);
                if (b == value) {
                    range.setInterval(start, absPos);
                    this.position(absPos + 1L);
                    assert (this.invariant(false));
                    return;
                }
                ++absPos;
            }
        }
        this.position(limit);
        assert (this.invariant(false));
        throw INCOMPLETE_READ;
    }

    @Override
    public void scanWhile(byte value, Range range) {
        byte b;
        int pos;
        assert (this.invariant(false));
        this.requireRemaining(1L);
        long start = this.position();
        long limit = this.limit();
        long last = limit - 1L;
        long fromPos = start + this.shrinkN;
        long toPos = last + this.shrinkN;
        int fromInd = (int)(fromPos >> (int)this.factor);
        int toInd = (int)(toPos >> (int)this.factor);
        int fromAddr = (int)(fromPos & this.addrMask);
        int toAddr = (int)(toPos & this.addrMask);
        assert (U.must((fromInd >= 0 ? 1 : 0) != 0, (String)"bad start: %s", (long)start));
        assert (U.must((toInd >= 0 ? 1 : 0) != 0, (String)"bad end: %s", (long)last));
        ByteBuffer src = this.bufs[fromInd];
        long absPos = start;
        for (pos = fromAddr; pos < this.singleCap; ++pos) {
            b = src.get(pos);
            if (b != value) {
                range.setInterval(start, absPos);
                this.position(absPos);
                assert (this.invariant(false));
                return;
            }
            ++absPos;
        }
        for (int i = fromInd + 1; i < toInd; ++i) {
            src = this.bufs[i];
            for (int pos2 = 0; pos2 < this.singleCap; ++pos2) {
                byte b2 = src.get(pos2);
                if (b2 != value) {
                    range.setInterval(start, absPos);
                    this.position(absPos);
                    assert (this.invariant(false));
                    return;
                }
                ++absPos;
            }
        }
        if (fromInd < toInd) {
            src = this.bufs[toInd];
            for (pos = 0; pos <= toAddr; ++pos) {
                b = src.get(pos);
                if (b != value) {
                    range.setInterval(start, absPos);
                    this.position(absPos);
                    assert (this.invariant(false));
                    return;
                }
                ++absPos;
            }
        }
        this.position(limit);
        assert (this.invariant(false));
        throw INCOMPLETE_READ;
    }

    private void requireRemaining(long n) {
        if (this.remaining() < n) {
            throw Buf.INCOMPLETE_READ;
        }
    }

    @Override
    public void skip(long count) {
        assert (this.invariant(false));
        this.requireRemaining(count);
        this._position += count;
        assert (this.invariant(false));
    }

    @Override
    public int bufferIndexOf(long position) {
        assert (this.invariant(false));
        assert (position >= 0L);
        this.validatePos(position, 1L);
        int index = (int)((position += this.shrinkN) >> (int)this.factor);
        assert (this.bufs[index] != null);
        assert (this.invariant(false));
        return index;
    }

    @Override
    public int bufferOffsetOf(long position) {
        assert (this.invariant(false));
        assert (position >= 0L);
        this.validatePos(position, 1L);
        position += this.shrinkN;
        assert (this.invariant(false));
        return (int)(position & this.addrMask);
    }

    @Override
    public int bufCount() {
        assert (this.invariant(false));
        return this.bufN;
    }

    @Override
    public OutputStream asOutputStream() {
        assert (this.invariant(false));
        if (this.outputStream == null) {
            this.outputStream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    assert (MultiBuf.this.invariant(true));
                    MultiBuf.this.append((byte)b);
                }
            };
        }
        assert (this.invariant(false));
        return this.outputStream;
    }

    @Override
    public String asText() {
        return this.get(new Range(0L, this.size()));
    }

    @Override
    public Bytes bytes() {
        assert (this.invariant(false));
        return this._bytes;
    }

    @Override
    public void scanLn(Range line) {
        assert (this.invariant(false));
        long pos = BytesUtil.parseLine(this.bytes(), line, this.position(), this.size());
        if (pos < 0L) {
            assert (this.invariant(false));
            throw INCOMPLETE_READ;
        }
        this._position = pos;
        assert (this.invariant(false));
    }

    @Override
    public void scanLnLn(Ranges lines) {
        assert (this.invariant(false));
        long pos = BytesUtil.parseLines(this.bytes(), lines, this.position(), this.size());
        if (pos < 0L) {
            assert (this.invariant(false));
            throw INCOMPLETE_READ;
        }
        this._position = pos;
        assert (this.invariant(false));
    }

    @Override
    public void scanN(long count, Range range) {
        assert (this.invariant(false));
        this.get(this._position + count - 1L);
        range.set(this._position, count);
        this._position += count;
        assert (this.invariant(false));
    }

    @Override
    public String readLn() {
        assert (this.invariant(false));
        this.scanLn(this.HELPER_RANGE);
        String result = this.get(this.HELPER_RANGE);
        assert (this.invariant(false));
        return result;
    }

    @Override
    public String readN(long count) {
        assert (this.invariant(false));
        this.scanN(count, this.HELPER_RANGE);
        String result = this.get(this.HELPER_RANGE);
        assert (this.invariant(false));
        return result;
    }

    @Override
    public byte[] readNbytes(int count) {
        assert (this.invariant(false));
        this.scanN(count, this.HELPER_RANGE);
        byte[] bytes = new byte[count];
        this.get(this.HELPER_RANGE, bytes, 0);
        assert (this.invariant(false));
        return bytes;
    }

    @Override
    public void scanTo(byte sep, Range range, boolean failOnLimit) {
        assert (this.invariant(false));
        long pos = BytesUtil.find(this.bytes(), this._position, this._limit, sep, true);
        if (pos >= 0L) {
            this.consumeAndSkip(pos, range, 1L);
        } else {
            if (failOnLimit) {
                assert (this.invariant(false));
                throw INCOMPLETE_READ;
            }
            this.consumeAndSkip(this._limit, range, 0L);
        }
        assert (this.invariant(false));
    }

    @Override
    public long scanTo(byte sep1, byte sep2, Range range, boolean failOnLimit) {
        boolean found2;
        assert (this.invariant(false));
        long pos1 = BytesUtil.find(this.bytes(), this._position, this._limit, sep1, true);
        long pos2 = BytesUtil.find(this.bytes(), this._position, this._limit, sep2, true);
        boolean found1 = pos1 >= 0L;
        boolean bl = found2 = pos2 >= 0L;
        if (found1 && found2) {
            if (pos1 <= pos2) {
                this.consumeAndSkip(pos1, range, 1L);
                assert (this.invariant(false));
                return 1L;
            }
            this.consumeAndSkip(pos2, range, 1L);
            assert (this.invariant(false));
            return 2L;
        }
        if (found1 && !found2) {
            this.consumeAndSkip(pos1, range, 1L);
            assert (this.invariant(false));
            return 1L;
        }
        if (!found1 && found2) {
            this.consumeAndSkip(pos2, range, 1L);
            assert (this.invariant(false));
            return 2L;
        }
        if (failOnLimit) {
            assert (this.invariant(false));
            throw INCOMPLETE_READ;
        }
        this.consumeAndSkip(this._limit, range, 0L);
        assert (this.invariant(false));
        return 0L;
    }

    private void consumeAndSkip(long toPos, Range range, long skip) {
        range.setInterval(this._position, toPos);
        this._position = toPos + skip;
    }

    @Override
    public void scanLnLn(Ranges ranges, LongWrap result, byte end1, byte end2) {
        assert (this.invariant(false));
        long nextPos = BytesUtil.parseLines(this.bytes(), ranges, result, this._position, this._limit, end1, end2);
        if (nextPos < 0L) {
            throw Buf.INCOMPLETE_READ;
        }
        this._position = nextPos;
        assert (this.invariant(false));
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public long checkpoint() {
        return this._checkpoint;
    }

    @Override
    public void checkpoint(long checkpoint) {
        this._checkpoint = checkpoint;
    }
}

