/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.bytes;

import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.UTILS;
import org.rapidoid.wrap.LongWrap;
import org.rapidoidx.bytes.ByteArrayBytes;
import org.rapidoidx.bytes.Bytes;
import org.rapidoidx.bytes.StringBytes;
import org.rapidoidx.data.Range;
import org.rapidoidx.data.Ranges;

public class BytesUtil
implements Constants {
    public static final byte[] CHARS_SWITCH_CASE = new byte[128];

    public static Bytes from(byte[] bytes) {
        return new ByteArrayBytes(bytes);
    }

    public static Bytes from(String s) {
        return new StringBytes(s);
    }

    public static long parseLines(Bytes bytes, Ranges lines, LongWrap res, long start, long limit, byte end1, byte end2) {
        byte b0 = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        long ret = -1L;
        res.value = Integer.MIN_VALUE;
        long from = start;
        for (long i = start; i < limit; ++i) {
            long len;
            b0 = b1;
            b1 = b2;
            b2 = b3;
            b3 = bytes.get(i);
            if (b3 != 10) continue;
            if (b2 == 13) {
                len = i - from - 1L;
                if (b0 == end1 && b1 == end2 && len > 0L) {
                    res.value = lines.count;
                }
            } else {
                len = i - from;
                if (b1 == end1 && b2 == end2 && len > 0L) {
                    res.value = lines.count;
                }
            }
            if (len == 0L) {
                ret = i + 1L;
                break;
            }
            lines.add(from, len);
            from = i + 1L;
        }
        return ret;
    }

    public static long parseLines(Bytes bytes, Ranges lines, long start, long limit) {
        byte b0 = 0;
        byte b1 = 0;
        long ret = -1L;
        long from = start;
        for (long i = start; i < limit; ++i) {
            b0 = b1;
            b1 = bytes.get(i);
            if (b1 != 10) continue;
            long len = b0 == 13 ? i - from - 1L : i - from;
            if (len == 0L) {
                ret = i + 1L;
                break;
            }
            lines.add(from, len);
            from = i + 1L;
        }
        return ret;
    }

    public static long parseLine(Bytes bytes, Range line, long start, long limit) {
        byte b0 = 0;
        byte b1 = 0;
        long ret = -1L;
        for (long i = start; i < limit; ++i) {
            b0 = b1;
            b1 = bytes.get(i);
            if (b1 != 10) continue;
            long len = b0 == 13 ? i - start - 1L : i - start;
            line.set(start, len);
            ret = i + 1L;
            break;
        }
        return ret;
    }

    public static Range getByPrefix(Bytes bytes, Ranges ranges, byte[] prefix, boolean caseSensitive) {
        for (int i = 0; i < ranges.count; ++i) {
            if (!BytesUtil.startsWith(bytes, ranges.ranges[i], prefix, caseSensitive)) continue;
            return ranges.ranges[i];
        }
        return null;
    }

    public static String get(Bytes bytes, Range range) {
        return new String(BytesUtil.getBytes(bytes, range));
    }

    public static byte[] getBytes(Bytes bytes, Range range) {
        byte[] byteArr = new byte[(int)range.length];
        for (int i = 0; i < byteArr.length; ++i) {
            byteArr[i] = bytes.get(range.start + (long)i);
        }
        return byteArr;
    }

    public static long scan(Bytes bytes, long from, long to, byte value) {
        for (long i = from; i <= to; ++i) {
            if (bytes.get(i) != value) continue;
            return i;
        }
        return -1L;
    }

    public static long scanNoCase(Bytes bytes, long from, long to, byte value) {
        for (long i = from; i <= to; ++i) {
            byte b = bytes.get(i);
            if (b != value && (b < 65 || CHARS_SWITCH_CASE[b] != value)) continue;
            return i;
        }
        return -1L;
    }

    public static boolean match(Bytes bytes, long start, byte[] match, int offset, int length, boolean caseSensitive) {
        boolean result = caseSensitive ? BytesUtil.matchSensitive(bytes, start, match, offset, length) : BytesUtil.matchNoCase(bytes, start, match, offset, length);
        return result;
    }

    public static boolean matchNoCase(Bytes bytes, long start, byte[] match, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            byte b = bytes.get(start + (long)i);
            if (b == match[offset + i] || b >= 65 && CHARS_SWITCH_CASE[b] == match[offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean matchSensitive(Bytes bytes, long start, byte[] match, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (bytes.get(start + (long)i) == match[offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean match(Bytes bytes, long start, byte[] match, boolean caseSensitive) {
        return BytesUtil.match(bytes, start, match, 0, match.length, caseSensitive);
    }

    public static long find(Bytes bytes, long start, long limit, byte match, boolean caseSensitive) {
        assert (start >= 0L);
        assert (limit >= 0L);
        if (limit - start < 1L) {
            return -1L;
        }
        if (caseSensitive) {
            return BytesUtil.scan(bytes, start, limit - 1L, match);
        }
        return BytesUtil.scanNoCase(bytes, start, limit - 1L, match);
    }

    public static long find(Bytes bytes, long start, long limit, byte[] match, boolean caseSensitive) {
        return BytesUtil.find(bytes, start, limit, match, 0, match.length, caseSensitive);
    }

    public static long find(Bytes bytes, long start, long limit, byte[] match, int offset, int length, boolean caseSensitive) {
        assert (start >= 0L);
        assert (limit >= 0L);
        assert (offset >= 0);
        assert (length >= 0);
        long result = caseSensitive ? BytesUtil.findSensitive(bytes, start, limit, match, offset, length) : BytesUtil.findNoCase(bytes, start, limit, match, offset, length);
        return result;
    }

    private static long findNoCase(Bytes bytes, long start, long limit, byte[] match, long offset, long length) {
        throw U.notReady();
    }

    private static long findSensitive(Bytes bytes, long start, long limit, byte[] match, int offset, int length) {
        if (limit - start < (long)length) {
            return -1L;
        }
        long pos = start;
        long last = limit - (long)length;
        while ((pos = BytesUtil.scan(bytes, pos, last, match[0])) >= 0L) {
            if (BytesUtil.matchSensitive(bytes, pos, match, offset, length)) {
                return pos;
            }
            ++pos;
        }
        return -1L;
    }

    public static boolean matches(Bytes bytes, Range target, byte[] match, boolean caseSensitive) {
        if (target.length != (long)match.length || target.start < 0L || target.last() >= bytes.limit()) {
            return false;
        }
        boolean result = BytesUtil.match(bytes, target.start, match, caseSensitive);
        return result;
    }

    public static boolean startsWith(Bytes bytes, Range target, byte[] match, boolean caseSensitive) {
        if (target.length < (long)match.length || target.start < 0L || target.last() >= bytes.limit()) {
            return false;
        }
        boolean result = BytesUtil.match(bytes, target.start, match, caseSensitive);
        return result;
    }

    public static boolean containsAt(Bytes bytes, Range target, long offset, byte[] match, boolean caseSensitive) {
        if (offset < 0L || target.length < offset + (long)match.length || target.start < 0L || target.last() >= bytes.limit()) {
            return false;
        }
        boolean result = BytesUtil.match(bytes, target.start + offset, match, caseSensitive);
        return result;
    }

    public static void trim(Bytes bytes, Range target) {
        long start;
        long len = target.length;
        long finish = start + len - 1L;
        if (start < 0L || len == 0L) {
            return;
        }
        for (start = target.start; start < finish && bytes.get(start) == 32; ++start) {
        }
        while (start < finish && bytes.get(finish) == 32) {
            --finish;
        }
        target.start = start;
        target.length = finish - start + 1L;
    }

    public static boolean split(Bytes bytes, Range target, byte sep, Range before, Range after, boolean trimParts) {
        long pos = BytesUtil.find(bytes, target.start, target.limit(), sep, true);
        if (pos >= 0L) {
            before.setInterval(target.start, pos);
            after.setInterval(pos + 1L, target.limit());
            if (trimParts) {
                BytesUtil.trim(bytes, before);
                BytesUtil.trim(bytes, after);
            }
            return true;
        }
        before.assign(target);
        after.reset();
        if (trimParts) {
            BytesUtil.trim(bytes, before);
        }
        return false;
    }

    public static long scanUntilAndMatchPrefix(Bytes bytes, Range result, byte separator, long fromPos, long toPos, long searchPrefix) {
        byte b3;
        byte b2;
        byte b1;
        byte b0;
        long p = fromPos;
        if (p <= toPos) {
            b0 = bytes.get(p);
            if (b0 == separator) {
                result.set(fromPos, 0L);
                return p + 1L;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b1 = bytes.get(p);
            if (b1 == separator) {
                result.set(fromPos, 1L);
                return p + 1L;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b2 = bytes.get(p);
            if (b2 == separator) {
                result.set(fromPos, 2L);
                return p + 1L;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b3 = bytes.get(p);
            if (b3 == separator) {
                result.set(fromPos, 3L);
                return p + 1L;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        long prefix = UTILS.intFrom((byte)b0, (byte)b1, (byte)b2, (byte)b3);
        boolean matchedPrefix = prefix == searchPrefix;
        for (long i = p; i <= toPos; ++i) {
            if (bytes.get(i) != separator) continue;
            result.setInterval(fromPos, i);
            long nextPos = i + 1L;
            return matchedPrefix ? -nextPos : nextPos;
        }
        result.reset();
        return Integer.MIN_VALUE;
    }

    public static long scanLnAndMatchPrefix(Bytes bytes, Range result, long fromPos, long toPos, long searchPrefix) {
        byte b3;
        byte b2;
        byte b1;
        byte b0;
        long p = fromPos;
        if (p <= toPos) {
            b0 = bytes.get(p);
            if (b0 == 10) {
                result.set(fromPos, 0L);
                return p + 1L;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b1 = bytes.get(p);
            if (b1 == 10) {
                if (b0 == 13) {
                    result.set(fromPos, 0L);
                } else {
                    result.set(fromPos, 1L);
                }
                return p + 1L;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b2 = bytes.get(p);
            if (b2 == 10) {
                if (b1 == 13) {
                    result.set(fromPos, 1L);
                } else {
                    result.set(fromPos, 2L);
                }
                return p + 1L;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b3 = bytes.get(p);
            if (b3 == 10) {
                if (b2 == 13) {
                    result.set(fromPos, 2L);
                } else {
                    result.set(fromPos, 3L);
                }
                return p + 1L;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        long prefix = UTILS.intFrom((byte)b0, (byte)b1, (byte)b2, (byte)b3);
        boolean matchedPrefix = prefix == searchPrefix;
        for (long i = p; i <= toPos; ++i) {
            if (bytes.get(i) != 10) continue;
            if (bytes.get(i - 1L) == 13) {
                result.setInterval(fromPos, i - 1L);
            } else {
                result.setInterval(fromPos, i);
            }
            long nextPos = i + 1L;
            return matchedPrefix ? -nextPos : nextPos;
        }
        result.reset();
        return Integer.MIN_VALUE;
    }

    static {
        for (int ch = 0; ch < 128; ++ch) {
            BytesUtil.CHARS_SWITCH_CASE[ch] = ch >= 97 && ch <= 122 ? (byte)(ch - 32) : (ch >= 65 && ch <= 90 ? (byte)(ch + 32) : (byte)ch);
        }
    }
}

