/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.data;

import org.rapidoid.u.U;
import org.rapidoidx.buffer.Buf;
import org.rapidoidx.bytes.Bytes;
import org.rapidoidx.bytes.BytesUtil;

public class Range {
    public static final Range NONE = new Range();
    public long start = -1L;
    public long length = 0L;

    public Range() {
    }

    public Range(long start, long length) {
        this.start = start;
        this.length = length;
    }

    public Range reset() {
        this.start = -1L;
        this.length = 0L;
        return this;
    }

    public long limit() {
        return this.start + this.length;
    }

    public long last() {
        return this.start + this.length - 1L;
    }

    public String toString() {
        return this.isEmpty() ? "[]" : "[" + this.start + ":" + this.length + "]";
    }

    public boolean isEmpty() {
        return this.start < 0L || this.length <= 0L;
    }

    public void ends(long endPos) {
        this.length = endPos - this.start;
    }

    public void starts(long startPos) {
        this.start = startPos;
    }

    public void set(long start, long length) {
        this.start = start;
        this.length = length;
    }

    public void setInterval(long start, long limit) {
        assert (start <= limit);
        this.start = start;
        this.length = limit - start;
    }

    public String get(String whole) {
        return this.start >= 0L ? whole.substring((int)this.start, (int)(this.start + this.length)) : "";
    }

    public byte[] bytes(Buf src) {
        byte[] bytes = new byte[(int)this.length];
        src.get(this, bytes, 0);
        return bytes;
    }

    public static Range fromTo(long from, long to) {
        U.must((from <= to ? 1 : 0) != 0, (String)"Invalid range!");
        return new Range(from, to - from);
    }

    public String str(Buf buf) {
        return BytesUtil.get(buf.bytes(), this);
    }

    public String str(Bytes bytes) {
        return BytesUtil.get(bytes, this);
    }

    public void assign(Range range) {
        this.set(range.start, range.length);
    }

    public void strip(long left, long right) {
        this.start += left;
        this.length -= left + right;
    }
}

