/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.net.impl;

import java.util.Map;
import org.rapidoidx.buffer.Buf;
import org.rapidoidx.buffer.BufProvider;
import org.rapidoidx.data.BinaryMultiData;
import org.rapidoidx.data.KeyValueRanges;
import org.rapidoidx.data.Range;

public class DefaultBinaryMultiData
implements BinaryMultiData {
    private final BufProvider src;
    private final KeyValueRanges ranges;

    public DefaultBinaryMultiData(BufProvider src, KeyValueRanges ranges) {
        this.src = src;
        this.ranges = ranges;
    }

    public Map<String, byte[]> get() {
        return this.ranges.toBinaryMap(this.src.buffer(), true);
    }

    public KeyValueRanges ranges() {
        return this.ranges;
    }

    public String toString() {
        return "BinaryMultiData [ranges=" + this.ranges + "]";
    }

    public byte[] get(String name) {
        Buf buf = this.src.buffer();
        Range range = this.ranges.get(buf, name.getBytes(), false);
        return range != null ? range.bytes(buf) : null;
    }
}

