/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.net.impl;

import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Resetable;
import org.rapidoidx.buffer.Buf;
import org.rapidoidx.buffer.BufProvider;
import org.rapidoidx.data.BinaryMultiData;
import org.rapidoidx.data.Data;
import org.rapidoidx.data.KeyValueRanges;
import org.rapidoidx.data.MultiData;
import org.rapidoidx.data.Range;
import org.rapidoidx.net.abstracts.Channel;
import org.rapidoidx.net.abstracts.ChannelHolder;
import org.rapidoidx.net.abstracts.ProtocolContext;
import org.rapidoidx.net.impl.ConnState;
import org.rapidoidx.net.impl.DecodedData;
import org.rapidoidx.net.impl.DefaultBinaryMultiData;
import org.rapidoidx.net.impl.DefaultData;
import org.rapidoidx.net.impl.DefaultMultiData;
import org.rapidoidx.net.impl.RapidoidHelper;

public abstract class DefaultExchange<T>
implements ProtocolContext<T>,
BufProvider,
Resetable,
Constants {
    protected Channel conn;
    protected AtomicLong totalWritten = new AtomicLong();

    public synchronized void reset() {
        this.conn = null;
        this.totalWritten.set(0L);
    }

    public void setConnection(Channel conn) {
        this.conn = conn;
    }

    @Override
    public String address() {
        return this.conn.address();
    }

    @Override
    public T write(String s) {
        byte[] bytes = s.getBytes();
        this.conn.write(bytes);
        return this.wrote(bytes.length);
    }

    @Override
    public T writeln(String s) {
        byte[] bytes = s.getBytes();
        this.conn.write(bytes);
        this.conn.write(CR_LF);
        return this.wrote(bytes.length + 2);
    }

    @Override
    public T write(byte[] bytes) {
        this.conn.write(bytes);
        return this.wrote(bytes.length);
    }

    @Override
    public T write(byte[] bytes, int offset, int length) {
        this.conn.write(bytes, offset, length);
        return this.wrote(length);
    }

    @Override
    public T write(ByteBuffer buf) {
        int n = buf.remaining();
        this.conn.write(buf);
        return this.wrote(n);
    }

    @Override
    public T write(File file) {
        long size = file.length();
        U.must((size < Integer.MAX_VALUE ? 1 : 0) != 0);
        this.conn.write(file);
        return this.wrote((int)size);
    }

    private T wrote(int count) {
        this.totalWritten.addAndGet(count);
        return this.me();
    }

    @Override
    public T close() {
        this.conn.close();
        return this.me();
    }

    @Override
    public T closeIf(boolean condition) {
        this.conn.closeIf(condition);
        return this.me();
    }

    @Override
    public Buf input() {
        return this.conn.input();
    }

    @Override
    public Buf output() {
        return this.conn.output();
    }

    @Override
    public String readln() {
        return this.conn.readln();
    }

    @Override
    public String readN(int count) {
        return this.conn.readN(count);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.conn.getAddress();
    }

    @Override
    public RapidoidHelper helper() {
        return this.conn.helper();
    }

    @Override
    public long connId() {
        return this.conn.connId();
    }

    protected Data data(Range range) {
        return new DefaultData(this, range);
    }

    protected Data decodedData(Range range) {
        return new DecodedData(this, range);
    }

    protected MultiData multiData(KeyValueRanges ranges) {
        return new DefaultMultiData(this, ranges);
    }

    protected BinaryMultiData binaryMultiData(KeyValueRanges ranges) {
        return new DefaultBinaryMultiData(this, ranges);
    }

    public Buf buffer() {
        return this.conn.input();
    }

    public long getTotalWritten() {
        return this.totalWritten.get();
    }

    @Override
    public T restart() {
        this.conn.restart();
        return this.me();
    }

    @Override
    public T async() {
        this.conn.async();
        return this.me();
    }

    @Override
    public boolean isAsync() {
        return this.conn.isAsync();
    }

    @Override
    public T done() {
        this.conn.done();
        return this.me();
    }

    @Override
    public T send() {
        this.conn.send();
        return this.me();
    }

    @Override
    public boolean isClosing() {
        return this.conn.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.conn.isClosed();
    }

    @Override
    public void waitUntilClosing() {
        this.conn.waitUntilClosing();
    }

    @Override
    public void log(String msg) {
        this.conn.log(msg);
    }

    @Override
    public synchronized boolean isInitial() {
        return this.conn.isInitial();
    }

    @Override
    public synchronized ConnState state() {
        return this.conn.state();
    }

    @Override
    public ChannelHolder createHolder() {
        return this.conn.createHolder();
    }

    protected T me() {
        return (T)this;
    }
}

