/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.net.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.rapidoid.annotation.Inject;
import org.rapidoid.cls.Cls;
import org.rapidoid.config.Conf;
import org.rapidoid.u.U;
import org.rapidoidx.buffer.BufGroup;
import org.rapidoidx.net.Protocol;
import org.rapidoidx.net.TCPClient;
import org.rapidoidx.net.TCPClientInfo;
import org.rapidoidx.net.abstracts.ChannelHolder;
import org.rapidoidx.net.impl.AbstractEventLoop;
import org.rapidoidx.net.impl.ChannelHolderImpl;
import org.rapidoidx.net.impl.ConnState;
import org.rapidoidx.net.impl.ConnectionTarget;
import org.rapidoidx.net.impl.DefaultExchange;
import org.rapidoidx.net.impl.RapidoidHelper;
import org.rapidoidx.net.impl.RapidoidWorker;

public class RapidoidClientLoop
extends AbstractEventLoop<TCPClient>
implements TCPClient,
TCPClientInfo {
    private RapidoidWorker[] workers;
    @Inject(optional=true)
    private String host = null;
    @Inject(optional=true)
    private int port = 80;
    @Inject(optional=true)
    private int workersN = Conf.cpus();
    @Inject(optional=true)
    private int bufSizeKB = 16;
    @Inject(optional=true)
    private boolean noDelay = false;
    @Inject(optional=true)
    private boolean autoreconnecting = false;
    @Inject(optional=true)
    private int connections = 0;
    private final Protocol protocol;
    private final Class<? extends RapidoidHelper> helperClass;
    private final Class<? extends DefaultExchange<?>> exchangeClass;
    private int currentWorkerInd = 0;

    public RapidoidClientLoop(Protocol protocol, Class<? extends DefaultExchange<?>> exchangeClass, Class<? extends RapidoidHelper> helperClass) {
        super("client");
        this.protocol = protocol;
        this.exchangeClass = exchangeClass;
        this.helperClass = (Class)U.or(helperClass, RapidoidHelper.class);
    }

    @Override
    protected void doProcessing() {
    }

    @Override
    protected final void beforeLoop() {
        try {
            this.openSockets();
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot open socket!", (Throwable)e);
        }
    }

    private void openSockets() throws IOException {
        int i;
        this.workers = new RapidoidWorker[this.workersN];
        for (i = 0; i < this.workers.length; ++i) {
            RapidoidHelper helper = (RapidoidHelper)Cls.newInstance(this.helperClass, (Object[])new Object[]{this.exchangeClass});
            String workerName = "client" + (i + 1);
            this.workers[i] = new RapidoidWorker(workerName, new BufGroup(13), null, helper, this.bufSizeKB, this.noDelay);
            new Thread((Runnable)this.workers[i], workerName).start();
        }
        for (i = 0; i < this.workers.length; ++i) {
            this.workers[i].waitToStart();
        }
    }

    @Override
    public synchronized ChannelHolder connect(String serverHost, int serverPort, Protocol clientProtocol, boolean autoreconnecting, ConnState state) {
        InetSocketAddress addr = new InetSocketAddress(serverHost, serverPort);
        SocketChannel socketChannel = RapidoidClientLoop.openSocket();
        ChannelHolderImpl holder = new ChannelHolderImpl();
        try {
            RapidoidWorker targetWorker = this.workers[this.currentWorkerInd];
            targetWorker.connect(new ConnectionTarget(socketChannel, addr, clientProtocol, holder, autoreconnecting, state));
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot create a TCP client connection!", (Throwable)e);
        }
        this.switchToNextWorker();
        return holder;
    }

    @Override
    public synchronized ChannelHolder[] connect(String serverHost, int serverPort, Protocol clientProtocol, int connectionsN, boolean autoreconnecting, ConnState state) {
        ChannelHolder[] holders = new ChannelHolder[connectionsN];
        for (int i = 0; i < connectionsN; ++i) {
            holders[i] = this.connect(serverHost, serverPort, clientProtocol, autoreconnecting, state);
        }
        return holders;
    }

    private synchronized void switchToNextWorker() {
        ++this.currentWorkerInd;
        if (this.currentWorkerInd == this.workers.length) {
            this.currentWorkerInd = 0;
        }
    }

    protected static SocketChannel openSocket() {
        try {
            SocketChannel socketChannel = SocketChannel.open();
            if (!socketChannel.isOpen()) {
                throw U.rte((String)"Cannot open socket!");
            }
            return socketChannel;
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot open socket!", (Throwable)e);
        }
    }

    @Override
    public synchronized TCPClient start() {
        new Thread((Runnable)this, "client").start();
        super.start();
        this.connect(this.host, this.port, this.protocol, this.connections, this.autoreconnecting, null);
        return this;
    }

    @Override
    public synchronized TCPClient shutdown() {
        this.stopLoop();
        for (RapidoidWorker worker : this.workers) {
            worker.stopLoop();
        }
        return (TCPClient)super.shutdown();
    }

    @Override
    public TCPClientInfo info() {
        return this;
    }

    @Override
    public long messagesProcessed() {
        long total = 0L;
        for (int i = 0; i < this.workers.length; ++i) {
            total += this.workers[i].getMessagesProcessed();
        }
        return total;
    }
}

