/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.net.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Resetable;
import org.rapidoidx.buffer.Buf;
import org.rapidoidx.buffer.BufGroup;
import org.rapidoidx.net.Protocol;
import org.rapidoidx.net.abstracts.Channel;
import org.rapidoidx.net.abstracts.ChannelHolder;
import org.rapidoidx.net.impl.ChannelHolderImpl;
import org.rapidoidx.net.impl.ConnState;
import org.rapidoidx.net.impl.CtxListener;
import org.rapidoidx.net.impl.IgnorantConnectionListener;
import org.rapidoidx.net.impl.RapidoidHelper;
import org.rapidoidx.net.impl.RapidoidWorker;

public class RapidoidConnection
implements Resetable,
Channel,
Constants {
    private static final CtxListener IGNORE = new IgnorantConnectionListener();
    private static final AtomicLong ID_N = new AtomicLong();
    public final RapidoidWorker worker;
    public final Buf input;
    public final Buf output;
    private final ConnState state = new ConnState();
    private boolean waitingToWrite = false;
    public volatile SelectionKey key;
    private boolean closeAfterWrite = false;
    public volatile boolean closed = true;
    public volatile boolean closing = false;
    volatile long completedInputPos;
    private CtxListener listener;
    private long id = ID_N.incrementAndGet();
    private boolean initial;
    private boolean async;
    volatile boolean done;
    private boolean isClient;
    private boolean autoReconnect;
    private Protocol protocol;
    private ChannelHolderImpl holder;
    public volatile int nextOp = 1;
    public volatile int mode = 0;

    public RapidoidConnection(RapidoidWorker worker, BufGroup bufs) {
        this.worker = worker;
        this.input = bufs.newBuf("input#" + this.connId());
        this.output = bufs.newBuf("output#" + this.connId());
        this.reset();
    }

    public synchronized void reset() {
        this.key = null;
        this.closed = true;
        this.closing = false;
        this.input.clear();
        this.output.clear();
        this.closeAfterWrite = false;
        this.waitingToWrite = false;
        this.completedInputPos = 0L;
        this.listener = IGNORE;
        this.initial = true;
        this.async = false;
        this.done = false;
        this.isClient = false;
        this.autoReconnect = false;
        this.protocol = null;
        this.holder = null;
        this.state.reset();
    }

    @Override
    public void log(String msg) {
        this.state().log(msg);
    }

    @Override
    public synchronized InetSocketAddress getAddress() {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        SocketAddress addr = socketChannel.socket().getRemoteSocketAddress();
        if (addr instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)addr;
            return address;
        }
        throw new IllegalStateException("Cannot get remote address!");
    }

    @Override
    public synchronized Channel write(String s) {
        this.output.append(s);
        return this;
    }

    @Override
    public synchronized Channel writeln(String s) {
        this.output.append(s);
        this.output.append(CR_LF);
        return this;
    }

    @Override
    public synchronized Channel write(byte[] bytes) {
        return this.write(bytes, 0, bytes.length);
    }

    @Override
    public synchronized Channel write(byte[] bytes, int offset, int length) {
        this.output.append(bytes, offset, length);
        return this;
    }

    @Override
    public synchronized Channel write(ByteBuffer buf) {
        this.output.append(buf);
        return this;
    }

    @Override
    public synchronized Channel write(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            FileChannel fileChannel = stream.getChannel();
            this.output.append((ReadableByteChannel)fileChannel);
            stream.close();
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        return this;
    }

    public synchronized boolean closeAfterWrite() {
        return this.closeAfterWrite;
    }

    @Override
    public synchronized Channel done() {
        this.done(null);
        return this;
    }

    public synchronized void done(Object tag) {
        this.async = false;
        if (!this.done) {
            this.done = true;
            this.askToSend();
            if (tag != null) {
                this.listener().onDone(this, tag);
            }
        }
    }

    @Override
    public synchronized Channel send() {
        this.askToSend();
        return this;
    }

    public synchronized void error() {
        this.askToSend();
    }

    private void askToSend() {
        if (!this.waitingToWrite && this.output.size() > 0L) {
            this.waitingToWrite = true;
            this.worker.wantToWrite(this);
        }
    }

    public synchronized void close(boolean waitToWrite) {
        if (waitToWrite) {
            this.done();
        }
        if (waitToWrite && this.waitingToWrite) {
            this.closeAfterWrite = true;
        } else {
            this.worker.close(this);
        }
    }

    public synchronized void wrote(boolean complete) {
        if (complete) {
            this.waitingToWrite = false;
        }
        this.input.deleteBefore(this.completedInputPos);
        this.completedInputPos = 0L;
    }

    @Override
    public synchronized Buf input() {
        return this.input;
    }

    @Override
    public synchronized Buf output() {
        return this.output;
    }

    public synchronized boolean onSameThread() {
        return this.worker.onSameThread();
    }

    @Override
    public synchronized RapidoidHelper helper() {
        return this.worker.helper;
    }

    public synchronized CtxListener listener() {
        return this.listener;
    }

    public synchronized void setListener(CtxListener listener) {
        this.listener = listener;
    }

    @Override
    public synchronized String address() {
        return this.getAddress().getAddress().getHostAddress();
    }

    @Override
    public synchronized Channel close() {
        this.close(true);
        return this;
    }

    @Override
    public synchronized Channel closeIf(boolean condition) {
        if (condition) {
            this.close();
        }
        return this;
    }

    @Override
    public synchronized String readln() {
        return this.input().readLn();
    }

    @Override
    public synchronized String readN(int count) {
        return this.input().readN((long)count);
    }

    @Override
    public synchronized long connId() {
        return this.id;
    }

    @Override
    public synchronized ConnState state() {
        return this.state;
    }

    @Override
    public synchronized boolean isInitial() {
        return this.initial;
    }

    public synchronized String toString() {
        return "conn#" + this.connId();
    }

    public synchronized void setInitial(boolean initial) {
        this.initial = initial;
    }

    @Override
    public synchronized Channel restart() {
        this.worker.restart(this);
        return this;
    }

    @Override
    public synchronized Channel async() {
        this.async = true;
        this.done = false;
        return this;
    }

    @Override
    public synchronized boolean isAsync() {
        return this.async;
    }

    public synchronized boolean isClient() {
        return this.isClient;
    }

    public synchronized void setClient(boolean isClient) {
        this.isClient = isClient;
    }

    public synchronized void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public synchronized Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public synchronized boolean isClosing() {
        return this.closing;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public void waitUntilClosing() {
        if (!this.isClosing()) {
            throw Buf.INCOMPLETE_READ;
        }
    }

    public synchronized ChannelHolderImpl getHolder() {
        return this.holder;
    }

    public synchronized void setHolder(ChannelHolderImpl holder) {
        this.holder = holder;
    }

    public synchronized boolean shouldReconnect() {
        return this.isClient && this.autoReconnect;
    }

    public synchronized void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    @Override
    public ChannelHolder createHolder() {
        return new ChannelHolderImpl(this);
    }

    @Override
    public Channel nextOp(int nextOp) {
        this.nextOp = nextOp;
        return this;
    }

    @Override
    public Channel nextWrite() {
        return this.nextOp(4);
    }

    @Override
    public Channel mode(int mode) {
        this.mode = mode;
        return this;
    }
}

