/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.frp;

import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rapidpm.frp.Transformations;
import org.rapidpm.frp.functions.QuadFunction;
import org.rapidpm.frp.functions.TriFunction;
import org.rapidpm.frp.matcher.Case;
import org.rapidpm.frp.model.Result;

public interface StringFunctions {
    public static BiFunction<String, String, Boolean> notStartsWith() {
        return (s, prefix) -> !s.startsWith((String)prefix);
    }

    public static TriFunction<String, String, Boolean, Boolean> notStartsWithCaseSensitive() {
        return (input, prefix, caseSensitive) -> caseSensitive != false ? Transformations.not().apply(input.startsWith((String)prefix)) : Transformations.not().apply(input.toLowerCase().startsWith(prefix.toLowerCase()));
    }

    public static Predicate<String> notEmpty() {
        return str -> Transformations.not().apply(str.isEmpty());
    }

    public static BiFunction<String, Integer, Result<String>> at() {
        return (value, humanIndex) -> {
            Case[] caseArray = new Case[4];
            caseArray[0] = Case.matchCase(() -> value == null, () -> Result.failure("value should not be null"));
            caseArray[1] = Case.matchCase(value::isEmpty, () -> Result.failure("value should not be empty"));
            caseArray[2] = Case.matchCase(() -> humanIndex - 1 >= value.length(), () -> Result.failure("index out of bounds"));
            caseArray[3] = Case.matchCase(() -> humanIndex - 1 < 0, () -> Result.failure("index out of lower bounds"));
            return Case.match(Case.matchCase(() -> Result.success(String.valueOf(value.charAt(humanIndex - 1)))), caseArray);
        };
    }

    public static Function<String, String> collapseWhitespace() {
        return input -> input.trim().replaceAll("\\s\\s+", " ");
    }

    public static BiFunction<String, String, Boolean> contains() {
        return (value, needle) -> StringFunctions.containsCaseSensitive().apply((String)value, (String)needle, false);
    }

    public static TriFunction<String, String, Boolean, Boolean> containsCaseSensitive() {
        return (value, needle, caseSensitive) -> (Boolean)Case.match(Case.matchCase(() -> Result.success(value.toLowerCase().contains(needle.toLowerCase()))), Case.matchCase(() -> caseSensitive, () -> Result.success(value.contains((CharSequence)needle)))).get();
    }

    public static BiFunction<String, String[], Boolean> containsAll() {
        return (value, needles) -> Arrays.stream(needles).allMatch(needle -> StringFunctions.containsCaseSensitive().apply((String)value, (String)needle, true));
    }

    public static TriFunction<String, String[], Boolean, Boolean> containsAllCaseSensitive() {
        return (value, needles, caseSensitive) -> Arrays.stream(needles).allMatch(needle -> StringFunctions.containsCaseSensitive().apply((String)value, (String)needle, (Boolean)caseSensitive));
    }

    public static BiFunction<String, String[], Boolean> containsAny() {
        return (value, needles) -> StringFunctions.containsAnyCaseSensitive().apply((String)value, (String[])needles, false);
    }

    public static TriFunction<String, String[], Boolean, Boolean> containsAnyCaseSensitive() {
        return (value, needles, caseSensitive) -> Arrays.stream(needles).anyMatch(needle -> StringFunctions.containsCaseSensitive().apply((String)value, (String)needle, (Boolean)caseSensitive));
    }

    public static BiFunction<String, String, Long> countSubStr() {
        return (value, subStr) -> StringFunctions.countSubStrCaseSensitive().apply((String)value, (String)subStr, true, false);
    }

    public static QuadFunction<String, String, Boolean, Boolean, Long> countSubStrCaseSensitive() {
        return (value, subStr, caseSensitive, allowOverlapping) -> StringFunctions.countSubStrCaseSensitiveOverlapping().apply(caseSensitive != false ? value : value.toLowerCase(), caseSensitive != false ? subStr : subStr.toLowerCase(), (Boolean)allowOverlapping, 0L);
    }

    public static QuadFunction<String, String, Boolean, Long, Long> countSubStrCaseSensitiveOverlapping() {
        return (value, subStr, allowOverlapping, count) -> {
            int position = value.indexOf((String)subStr);
            if (position == -1) {
                return count;
            }
            int offset = allowOverlapping == false ? position + subStr.length() : position + 1;
            count = count + 1L;
            return StringFunctions.countSubStrCaseSensitiveOverlapping().apply(value.substring(offset), (String)subStr, (Boolean)allowOverlapping, (Long)count);
        };
    }

    public static BiFunction<String, String, Boolean> endsWith() {
        return (value, search) -> StringFunctions.endsWithCaseSensitive().apply((String)value, (String)search, true);
    }

    public static TriFunction<String, String, Boolean, Boolean> endsWithCaseSensitive() {
        return (value, search, caseSensitive) -> StringFunctions.endsWithCaseSensitiveUpTo().apply((String)value, (String)search, value.length(), (Boolean)caseSensitive);
    }

    public static QuadFunction<String, String, Integer, Boolean, Boolean> endsWithCaseSensitiveUpTo() {
        return (value, search, position, caseSensitive) -> {
            int remainingLength = position - search.length();
            return caseSensitive.booleanValue() ? value.indexOf((String)search, remainingLength) > -1 : value.toLowerCase().indexOf(search.toLowerCase(), remainingLength) > -1;
        };
    }

    public static BiFunction<String, String, String> ensureLeft() {
        return (input, prefix) -> StringFunctions.ensureLeftCaseSensitive().apply((String)input, (String)prefix, true);
    }

    public static TriFunction<String, String, Boolean, String> ensureLeftCaseSensitive() {
        return (input, prefix, caseSensitive) -> caseSensitive.booleanValue() ? (input.startsWith((String)prefix) ? input : prefix + input) : (input.toLowerCase().startsWith(prefix.toLowerCase()) ? input : prefix + input);
    }

    public static Function<String, String> base64Decode() {
        return input -> new String(Base64.getDecoder().decode((String)input)).intern();
    }

    public static Function<String, String> base64Encode() {
        return input -> Base64.getEncoder().encodeToString(input.getBytes());
    }

    public static BiFunction<String, String[], String> appendArray() {
        return (input, appends) -> StringFunctions.appendStream().apply((String)input, Arrays.stream(appends));
    }

    public static BiFunction<String, Stream<String>, String> appendStream() {
        return (input, appendStream) -> Stream.concat(Stream.of(input), appendStream).collect(Collectors.joining());
    }

    public static BiFunction<String, String, String> append() {
        return (input, append) -> StringFunctions.appendStream().apply((String)input, Stream.of(append));
    }

    public static BiFunction<String, Collection<String>, String> appendCollection() {
        return (input, appendCollection) -> StringFunctions.appendStream().apply((String)input, appendCollection.stream());
    }

    public static BiFunction<String, Integer, String> repeat() {
        return (input, repeat) -> Stream.generate(() -> input).limit(repeat.intValue()).collect(Collectors.joining());
    }

    public static TriFunction<String, String, Integer, String> leftPad() {
        return (value, pad, length) -> value.length() > length ? value : StringFunctions.append().apply(StringFunctions.repeat().apply((String)pad, length - value.length()), (String)value);
    }

    public static TriFunction<String, Integer, Integer, String> decode() {
        return (value, digits, radix) -> Arrays.stream(value.split("(?<=\\G.{" + digits + "})")).map(data -> String.valueOf(Character.toChars(Integer.parseInt(data, radix)))).collect(Collectors.joining());
    }

    public static TriFunction<String, Integer, Integer, String> encode() {
        return (value, digits, radix) -> value.chars().mapToObj(ch -> StringFunctions.leftPad().apply(Integer.toString(ch, radix), "0", (Integer)digits)).collect(Collectors.joining());
    }

    public static Function<String, String> binDecode() {
        return value -> StringFunctions.decode().apply((String)value, 16, 2);
    }

    public static Function<String, String> binEncode() {
        return value -> StringFunctions.encode().apply((String)value, 16, 2);
    }

    public static Function<String, String> decDecode() {
        return value -> StringFunctions.decode().apply((String)value, 5, 10);
    }

    public static Function<String, String> decEncode() {
        return value -> StringFunctions.encode().apply((String)value, 5, 10);
    }

    public static BiFunction<String, String, String> ensureRight() {
        return (value, suffix) -> StringFunctions.ensureRightCaseSensitive().apply((String)value, (String)suffix, true);
    }

    public static TriFunction<String, String, Boolean, String> ensureRightCaseSensitive() {
        return (value, suffix, caseSensitive) -> StringFunctions.endsWithCaseSensitive().apply((String)value, (String)suffix, (Boolean)caseSensitive) != false ? value : StringFunctions.append().apply((String)value, (String)suffix);
    }

    public static BiFunction<String, Integer, String> first() {
        return (value, n) -> value.substring(0, (int)n);
    }

    public static Function<String, String> head() {
        return value -> StringFunctions.first().apply((String)value, 1);
    }

    public static BiFunction<String, String[], String> format() {
        return (input, params) -> {
            Pattern p = Pattern.compile("\\{(\\w+)\\}");
            Matcher m = p.matcher((CharSequence)input);
            String result = input;
            while (m.find()) {
                int paramNumber = Integer.parseInt(m.group(1));
                if (params == null || paramNumber >= ((String[])params).length) {
                    throw new IllegalArgumentException("params does not have value for " + m.group());
                }
                result = result.replace(m.group(), params[paramNumber]);
            }
            return result;
        };
    }

    public static Function<String, String> hexDecode() {
        return input -> StringFunctions.decode().apply((String)input, 4, 16);
    }

    public static Function<String, String> hexEncode() {
        return input -> StringFunctions.encode().apply((String)input, 4, 16);
    }

    public static QuadFunction<String, String, Integer, Boolean, Integer> indexOfCoseSensitive() {
        return (value, needle, offset, caseSensitive) -> caseSensitive != false ? value.indexOf((String)needle, (int)offset) : value.toLowerCase().indexOf(needle.toLowerCase(), (int)offset);
    }

    public static BiFunction<String, String, Boolean> inEqual() {
        return (first, second) -> !Objects.equals(first, second);
    }

    public static TriFunction<String, String, Integer, String> insert() {
        return (value, subStr, index) -> index > value.length() ? value : StringFunctions.appendStream().apply(value.substring(0, (int)index), Stream.of(subStr, value.substring((int)index)));
    }

    public static Function<String, Boolean> isUpperCase() {
        return input -> Objects.equals(input, input.toUpperCase());
    }

    public static Function<String, Boolean> isLowerCase() {
        return input -> Objects.equals(input, input.toLowerCase());
    }

    public static BiFunction<String, Integer, String> last() {
        return (value, n) -> n > value.length() ? value : value.substring(value.length() - n);
    }

    public static boolean isString(Object value) {
        if (Objects.isNull(value)) {
            throw new IllegalArgumentException("value can't be null");
        }
        return value instanceof String;
    }

    public static BiFunction<String, String, Integer> lastIndexOf() {
        return (value, needle) -> StringFunctions.lastIndexOfCaseSensitive().apply((String)value, (String)needle, true);
    }

    public static TriFunction<String, String, Boolean, Integer> lastIndexOfCaseSensitive() {
        return (value, needle, caseSensitive) -> StringFunctions.lastIndexOfCaseSensitiveWithIndexOf().apply((String)value, (String)needle, value.length(), (Boolean)caseSensitive);
    }

    public static QuadFunction<String, String, Integer, Boolean, Integer> lastIndexOfCaseSensitiveWithIndexOf() {
        return (value, needle, offset, caseSensitive) -> caseSensitive != false ? value.lastIndexOf((String)needle, (int)offset) : value.toLowerCase().lastIndexOf(needle.toLowerCase(), (int)offset);
    }

    public static Function<String, String> leftTrim() {
        return value -> value.replaceAll("^\\s+", "");
    }

    public static Function<String, Integer> length() {
        return String::length;
    }

    public static BiFunction<String, String[], String> prependArray() {
        return (value, array) -> Arrays.stream(array).collect(Collectors.joining()) + value;
    }

    public static BiFunction<String, Stream<String>, String> prependStream() {
        return (value, stream) -> stream.collect(Collectors.joining()) + value;
    }

    public static Function<String[], String[]> removeEmptyStrings() {
        return input -> (String[])Arrays.stream(input).filter(Objects::nonNull).map(String::trim).filter(StringFunctions.notEmpty()).toArray(String[]::new);
    }

    public static BiFunction<String, String, String> removeLeft() {
        return (input, prefix) -> input.startsWith((String)prefix) ? input.replaceFirst((String)prefix, "") : input;
    }

    public static TriFunction<String, String, Boolean, String> removeFromLeftCaseSensitive() {
        return (input, prefix, caseSenstive) -> caseSenstive != false ? StringFunctions.removeLeft().apply((String)input, (String)prefix) : (StringFunctions.notStartsWithCaseSensitive().apply((String)input, (String)prefix, false) != false ? input : input.substring(prefix.length()));
    }

    public static BiFunction<String, String, Boolean> startsWith() {
        return String::startsWith;
    }

    public static Function<String, String> removeNonWord() {
        return value -> value.replaceAll("[^\\w]+", "");
    }

    public static BiFunction<String, String, String> removeRight() {
        return (value, suffix) -> StringFunctions.removeRightCaseSensitive().apply((String)value, (String)suffix, true);
    }

    public static TriFunction<String, String, Boolean, String> removeRightCaseSensitive() {
        return (value, suffix, caseSensitive) -> StringFunctions.endsWithCaseSensitive().apply((String)value, (String)suffix, (Boolean)caseSensitive) != false ? value.substring(0, value.toLowerCase().lastIndexOf(suffix.toLowerCase())) : value;
    }

    public static Function<String, String> removeSpaces() {
        return value -> value.replaceAll("\\s", "");
    }

    public static QuadFunction<String, String, String, Boolean, String> replace() {
        return (value, search, newValue, caseSensitive) -> caseSensitive != false ? value.replaceAll((String)search, (String)newValue) : Pattern.compile(search, 2).matcher((CharSequence)value).replaceAll(Matcher.quoteReplacement(newValue));
    }

    public static Function<String, String> reverse() {
        return value -> new StringBuilder((String)value).reverse().toString();
    }

    public static TriFunction<String, String, Integer, String> rightPad() {
        return (value, pad, length) -> value.length() > length ? value : StringFunctions.append().apply((String)value, StringFunctions.repeat().apply((String)pad, length - value.length()));
    }

    public static Function<String, String> rightTrim() {
        return value -> value.replaceAll("\\s+$", "");
    }

    public static BiFunction<String, String, String[]> split() {
        return String::split;
    }

    public static BiFunction<String, String, Stream<String>> splitStream() {
        return (input, regex) -> Arrays.stream(input.split((String)regex));
    }

    public static BiFunction<String[], String, String> join() {
        return (strings, sperator) -> Arrays.stream(strings).collect(Collectors.joining(sperator));
    }

    public static Function<String, Stream<String>> wordStream() {
        return input -> Arrays.stream(input.split("\\W+"));
    }

    public static TriFunction<String, Integer, String, String> truncate() {
        return (value, length, filler) -> (String)Case.match(Case.matchCase(() -> Result.success(StringFunctions.append().apply(value.substring(0, length - filler.length()), (String)filler))), Case.matchCase(() -> length == 0, () -> Result.success("")), Case.matchCase(() -> length >= value.length(), () -> Result.success(value))).get();
    }

    public static Function<String, String[]> chars() {
        return input -> input.split("");
    }

    public static Function<String, Stream<String>> charsStream() {
        return input -> Arrays.stream(input.split(""));
    }

    public static Function<String, String> shuffle() {
        return input -> {
            String[] chars = StringFunctions.chars().apply((String)input);
            Random random = new Random();
            for (int i = 0; i < chars.length; ++i) {
                int r = random.nextInt(chars.length);
                String tmp = chars[i];
                chars[i] = chars[r];
                chars[r] = tmp;
            }
            return Arrays.stream(chars).collect(Collectors.joining());
        };
    }

    public static TriFunction<String, Integer, Integer, String> slice() {
        return String::substring;
    }

    public static TriFunction<String, String, String, String> surround() {
        return (value, prefix, suffix) -> (String)Case.match(Case.matchCase(() -> Result.success(prefix + value + suffix)), Case.matchCase(() -> prefix == null && suffix == null, () -> Result.success(value)), Case.matchCase(() -> prefix != null && suffix == null, () -> Result.success(prefix + value + prefix)), Case.matchCase(() -> prefix == null && suffix != null, () -> Result.success(suffix + value + suffix))).get();
    }

    public static Function<String, String> toCamelCase() {
        return value -> StringFunctions.toStudlyCase().apply((String)value).substring(0, 1).toLowerCase() + StringFunctions.toStudlyCase().apply((String)value).substring(1);
    }

    public static Function<String, String> toStudlyCase() {
        return value -> StringFunctions.splitStream().apply(StringFunctions.collapseWhitespace().apply(value.trim()), "\\s*(_|-|\\s)\\s*").filter(w -> !w.trim().isEmpty()).map(w -> StringFunctions.head().apply((String)w).toUpperCase() + StringFunctions.tail().apply((String)w)).collect(Collectors.joining());
    }

    public static Function<String, String> tail() {
        return value -> StringFunctions.last().apply((String)value, value.length() - 1);
    }

    public static BiFunction<String, String, String> toDecamelize() {
        return (value, chr) -> StringFunctions.splitStream().apply(StringFunctions.toCamelCase().apply((String)value), "(?=\\p{Upper})").map(String::toLowerCase).collect(Collectors.joining(chr));
    }

    public static Function<String, String> toKebabCase() {
        return value -> StringFunctions.toDecamelize().apply((String)value, "-");
    }

    public static Function<String, String> toSnakeCase() {
        return value -> StringFunctions.toDecamelize().apply((String)value, "_");
    }

    public static Function<String, String> capitalize() {
        return input -> input.length() == 0 ? "" : Optional.ofNullable(StringFunctions.head().apply((String)input)).map(String::toUpperCase).map(h -> Optional.ofNullable(StringFunctions.tail().apply((String)input)).map(t -> h + t.toLowerCase()).orElse((String)h)).get();
    }

    public static Function<String, String> lowerFirst() {
        return input -> input.length() == 0 ? "" : Optional.ofNullable(StringFunctions.head().apply((String)input)).map(String::toLowerCase).map(h -> Optional.ofNullable(StringFunctions.tail().apply((String)input)).map(t -> h + t).orElse((String)h)).get();
    }

    public static BiFunction<String, String, Boolean> isEnclosedBetween() {
        return (input, encloser) -> input.startsWith((String)encloser) && input.startsWith((String)encloser);
    }

    public static TriFunction<String, String, String, Boolean> isEnclosedBetweenBoth() {
        return (input, left, right) -> input.startsWith((String)left) && input.startsWith((String)right);
    }

    public static Function<String, String> upperFirst() {
        return input -> Optional.ofNullable(StringFunctions.head().apply((String)input)).map(String::toUpperCase).map(h -> Optional.ofNullable(StringFunctions.tail().apply((String)input)).map(t -> h + t).orElse((String)h)).get();
    }
}

