/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.frp;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.rapidpm.frp.functions.TriFunction;

public interface Transformations {
    public static Function<Boolean, Boolean> not() {
        return input -> input == false;
    }

    public static <T, U, V> Function<Function<U, V>, Function<Function<T, U>, Function<T, V>>> higherCompose() {
        return f -> g -> x -> f.apply(g.apply(x));
    }

    public static <T> Function<Enumeration<T>, Stream<T>> enumToStream() {
        return e -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>((Enumeration)e){
            final /* synthetic */ Enumeration val$e;
            {
                this.val$e = enumeration;
            }

            @Override
            public T next() {
                return this.val$e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return this.val$e.hasMoreElements();
            }
        }, 16), false);
    }

    public static <A, B, R> Function<BiFunction<A, B, R>, Function<A, Function<B, R>>> curryBiFunction() {
        return func -> a -> b -> func.apply(a, b);
    }

    public static <A, B, R> Function<Function<A, Function<B, R>>, BiFunction<A, B, R>> unCurryBifunction() {
        return func -> (a, b) -> ((Function)func.apply(a)).apply(b);
    }

    public static <A, B, C, R> Function<TriFunction<A, B, C, R>, Function<A, Function<B, Function<C, R>>>> curryTriFunction() {
        return func -> a -> b -> c -> func.apply(a, b, c);
    }

    public static <A, B, C, R> Function<Function<A, Function<B, Function<C, R>>>, TriFunction<A, B, C, R>> unCurryTrifunction() {
        return func -> (a, b, c) -> ((Function)((Function)func.apply(a)).apply(b)).apply(c);
    }

    public static <T> Predicate<T> not(Predicate<T> p) {
        return t -> !p.test(t);
    }

    public static <T> Predicate<T> asPredicate(Predicate<T> predicate) {
        return predicate;
    }

    public static <T> Consumer<T> asConsumer(Consumer<T> consumer) {
        return consumer;
    }

    public static <T> Supplier<T> asSupplier(Supplier<T> supplier) {
        return supplier;
    }

    public static <T, R> Function<T, R> asFunc(Function<T, R> function) {
        return function;
    }
}

