/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.frp.matcher;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.rapidpm.frp.model.Pair;
import org.rapidpm.frp.model.Result;

public class Case<T>
extends Pair<Supplier<Boolean>, Supplier<Result<T>>> {
    public Case(Supplier<Boolean> booleanSupplier, Supplier<Result<T>> resultSupplier) {
        super(booleanSupplier, resultSupplier);
    }

    public static <T> Case<T> matchCase(Supplier<Boolean> condition, Supplier<Result<T>> value) {
        return new Case<T>(condition, value);
    }

    public static <T> DefaultCase<T> matchCase(Supplier<Result<T>> value) {
        return new DefaultCase<T>(() -> true, value);
    }

    public boolean isMatching() {
        return (Boolean)((Supplier)this.getT1()).get();
    }

    public Result<T> result() {
        return (Result)((Supplier)this.getT2()).get();
    }

    @SafeVarargs
    public static <T> Result<T> match(DefaultCase<T> defaultCase, Case<T> ... matchers) {
        return Stream.of(matchers).filter(Case::isMatching).map(Case::result).findFirst().orElseGet(defaultCase::result);
    }

    public static class DefaultCase<T>
    extends Case<T> {
        public DefaultCase(Supplier<Boolean> booleanSupplier, Supplier<Result<T>> resultSupplier) {
            super(booleanSupplier, resultSupplier);
        }
    }
}

