/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.frp.model;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface Result<T> {
    public void ifPresentOrElse(Consumer<? super T> var1, Runnable var2);

    public void ifPresentOrElse(Consumer<T> var1, Consumer<String> var2);

    public void ifPresentOrElseAsync(Consumer<? super T> var1, Runnable var2);

    public void ifPresentOrElseAsync(Consumer<T> var1, Consumer<String> var2);

    public static <T> Result<T> failure(String errorMessage) {
        Objects.requireNonNull(errorMessage);
        return new Failure(errorMessage);
    }

    public static <T> Result<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> Result<T> ofNullable(T value) {
        return Result.ofNullable(value, "Object was null");
    }

    public static <T> Result<T> ofNullable(T value, String failedMessage) {
        return Objects.nonNull(value) ? Result.success(value) : Result.failure(failedMessage);
    }

    public T get();

    public T getOrElse(Supplier<T> var1);

    public Boolean isPresent();

    public Boolean isAbsent();

    public void ifPresent(Consumer<T> var1);

    public void ifAbsent(Runnable var1);

    default public Stream<T> stream() {
        if (!this.isPresent().booleanValue()) {
            return Stream.empty();
        }
        return Stream.of(this.get());
    }

    default public Result<T> or(Supplier<? extends Result<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent().booleanValue()) {
            return this;
        }
        Result<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    default public Optional<T> toOptional() {
        return Optional.ofNullable(this.get());
    }

    public static <T> Result<T> fromOptional(Optional<T> optional) {
        Objects.requireNonNull(optional);
        return Result.ofNullable(optional.get(), "Optional hold a null value");
    }

    default public <V, R> Result<R> thenCombine(V value, BiFunction<T, V, Result<R>> func) {
        return func.apply(this.get(), value);
    }

    default public <V, R> CompletableFuture<Result<R>> thenCombineAsync(V value, BiFunction<T, V, Result<R>> func) {
        return CompletableFuture.supplyAsync(() -> (Result)func.apply(this.get(), value));
    }

    default public <U> Result<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() != false ? Result.ofNullable(mapper.apply(this.get())) : Result.failure("Value was null, could not apply the mapper function");
    }

    public static class Failure<T>
    extends AbstractResult<T> {
        private final String errorMessage;

        public Failure(String errorMessage) {
            super(null);
            this.errorMessage = errorMessage;
        }

        @Override
        public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
            emptyAction.run();
        }

        @Override
        public void ifPresentOrElse(Consumer<T> success, Consumer<String> failure) {
            failure.accept(this.errorMessage);
        }

        @Override
        public void ifPresentOrElseAsync(Consumer<? super T> action, Runnable emptyAction) {
            CompletableFuture.runAsync(emptyAction);
        }

        @Override
        public void ifPresentOrElseAsync(Consumer<T> success, Consumer<String> failure) {
            CompletableFuture.runAsync(() -> failure.accept(this.errorMessage));
        }
    }

    public static class Success<T>
    extends AbstractResult<T> {
        public Success(T value) {
            super(value);
        }

        @Override
        public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
            action.accept(this.value);
        }

        @Override
        public void ifPresentOrElse(Consumer<T> success, Consumer<String> failure) {
            success.accept(this.value);
        }

        @Override
        public void ifPresentOrElseAsync(Consumer<? super T> action, Runnable emptyAction) {
            CompletableFuture.runAsync(() -> action.accept(this.value));
        }

        @Override
        public void ifPresentOrElseAsync(Consumer<T> success, Consumer<String> failure) {
            CompletableFuture.runAsync(() -> success.accept(this.value));
        }
    }

    public static abstract class AbstractResult<T>
    implements Result<T> {
        protected final T value;

        public AbstractResult(T value) {
            this.value = value;
        }

        @Override
        public void ifPresent(Consumer<T> consumer) {
            Objects.requireNonNull(consumer);
            if (this.value != null) {
                consumer.accept(this.value);
            }
        }

        @Override
        public void ifAbsent(Runnable action) {
            Objects.requireNonNull(action);
            if (this.value == null) {
                action.run();
            }
        }

        @Override
        public Boolean isPresent() {
            return this.value != null ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Boolean isAbsent() {
            return this.value == null ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public T get() {
            return Objects.requireNonNull(this.value);
        }

        @Override
        public T getOrElse(Supplier<T> supplier) {
            Objects.requireNonNull(supplier);
            return this.value != null ? this.value : Objects.requireNonNull(supplier.get());
        }
    }
}

