/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.vaadin.addons.testbench.junit5.extensions.unittest;

import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.WebDriver;
import org.rapidpm.dependencies.core.logger.HasLogger;
import org.rapidpm.frp.model.Result;
import org.rapidpm.vaadin.addons.webdriver.junit5.WebdriverExtensionFunctions;

public class ConvertWebdriverTestExtension
implements BeforeEachCallback,
AfterEachCallback,
HasLogger {
    public void beforeEach(ExtensionContext context) throws Exception {
        this.logger().info("beforeEach  -> convert WebDriver to VaadinWebDriver");
        Result.ofNullable((Object)((WebDriver)WebdriverExtensionFunctions.webdriver().apply(context))).ifPresentOrElse(webDriver -> {
            WebdriverExtensionFunctions.removeWebDriver().accept(context);
            WebdriverExtensionFunctions.storeWebDriver().accept(context, TestBench.createDriver((WebDriver)webDriver));
        }, failed -> this.logger().warning(failed));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.logger().info("afterEach  -> convert VaadinWebDriver to WebDriver");
        Result.ofNullable((Object)((WebDriver)WebdriverExtensionFunctions.webdriver().apply(context))).ifPresentOrElse(webDriver -> {
            if (webDriver instanceof TestBenchDriverProxy) {
                WebdriverExtensionFunctions.removeWebDriver().accept(context);
                WebdriverExtensionFunctions.storeWebDriver().accept(context, ((TestBenchDriverProxy)webDriver).getWrappedDriver());
            }
        }, failed -> this.logger().warning(failed));
    }
}

