/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rarefiedredis.redis.NotFloatException;
import org.rarefiedredis.redis.NotFloatMinMaxException;
import org.rarefiedredis.redis.NotImplementedException;
import org.rarefiedredis.redis.NotIntegerException;
import org.rarefiedredis.redis.NotValidStringRangeItemException;
import org.rarefiedredis.redis.ScanResult;
import org.rarefiedredis.redis.SyntaxErrorException;
import org.rarefiedredis.redis.WrongTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IRedisSortedSet {
    public Long zadd(String var1, ZsetPair var2, ZsetPair ... var3) throws WrongTypeException, NotImplementedException;

    public Long zadd(String var1, double var2, String var4, Object ... var5) throws WrongTypeException, NotImplementedException, SyntaxErrorException, NotFloatException;

    public Long zcard(String var1) throws WrongTypeException, NotImplementedException;

    public Long zcount(String var1, double var2, double var4) throws WrongTypeException, NotImplementedException;

    public String zincrby(String var1, double var2, String var4) throws WrongTypeException, NotImplementedException;

    public Long zinterstore(String var1, int var2, String ... var3) throws WrongTypeException, SyntaxErrorException, NotImplementedException;

    public Long zlexcount(String var1, String var2, String var3) throws WrongTypeException, NotValidStringRangeItemException, NotImplementedException;

    public Set<ZsetPair> zrange(String var1, long var2, long var4, String ... var6) throws WrongTypeException, NotImplementedException;

    public Set<ZsetPair> zrangebylex(String var1, String var2, String var3, String ... var4) throws WrongTypeException, NotValidStringRangeItemException, NotImplementedException;

    public Set<ZsetPair> zrevrangebylex(String var1, String var2, String var3, String ... var4) throws WrongTypeException, NotValidStringRangeItemException, NotImplementedException;

    public Set<ZsetPair> zrangebyscore(String var1, String var2, String var3, String ... var4) throws WrongTypeException, NotFloatMinMaxException, NotIntegerException, SyntaxErrorException, NotImplementedException;

    public Long zrank(String var1, String var2) throws WrongTypeException, NotImplementedException;

    public Long zrem(String var1, String var2, String ... var3) throws WrongTypeException, NotImplementedException;

    public Long zremrangebylex(String var1, String var2, String var3) throws WrongTypeException, NotValidStringRangeItemException, NotImplementedException;

    public Long zremrangebyrank(String var1, long var2, long var4) throws WrongTypeException, NotImplementedException;

    public Long zremrangebyscore(String var1, String var2, String var3) throws WrongTypeException, NotFloatMinMaxException, NotImplementedException;

    public Set<ZsetPair> zrevrange(String var1, long var2, long var4, String ... var6) throws WrongTypeException, NotImplementedException;

    public Set<ZsetPair> zrevrangebyscore(String var1, String var2, String var3, String ... var4) throws WrongTypeException, NotFloatMinMaxException, NotIntegerException, SyntaxErrorException, NotImplementedException;

    public Long zrevrank(String var1, String var2) throws WrongTypeException, NotImplementedException;

    public Double zscore(String var1, String var2) throws WrongTypeException, NotImplementedException;

    public Long zunionstore(String var1, int var2, String ... var3) throws WrongTypeException, SyntaxErrorException, NotImplementedException;

    public ScanResult<Set<ZsetPair>> zscan(String var1, long var2, String ... var4) throws WrongTypeException, NotImplementedException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ZsetPair {
        public String member;
        public Double score;

        public ZsetPair() {
            this.member = null;
            this.score = null;
        }

        public ZsetPair(String member) {
            this.member = member;
            this.score = null;
        }

        public ZsetPair(String member, Double score) {
            this.member = member;
            this.score = score;
        }

        public ZsetPair(Double score, String member) {
            this.member = member;
            this.score = score;
        }

        public static Set<String> members(Set<ZsetPair> pairs) {
            HashSet<String> set = new HashSet<String>();
            for (ZsetPair pair : pairs) {
                set.add(pair.member);
            }
            return set;
        }

        public static Map<String, Double> asMap(Set<ZsetPair> pairs) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            for (ZsetPair pair : pairs) {
                map.put(pair.member, pair.score);
            }
            return map;
        }

        public static Comparator<ZsetPair> comparator() {
            return new Comparator<ZsetPair>(){

                @Override
                public int compare(ZsetPair a, ZsetPair b) {
                    if (a == null) {
                        if (b == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (b == null) {
                        return -1;
                    }
                    if (a.score != null && b.score != null) {
                        if (a.score < b.score) {
                            return -1;
                        }
                        if (a.score > b.score) {
                            return 1;
                        }
                    }
                    return a.member.compareTo(b.member);
                }
            };
        }

        public static Comparator<ZsetPair> descendingComparator() {
            return new Comparator<ZsetPair>(){

                @Override
                public int compare(ZsetPair a, ZsetPair b) {
                    if (a == null) {
                        if (b == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (b == null) {
                        return -1;
                    }
                    if (a.score != null && b.score != null) {
                        if (a.score < b.score) {
                            return 1;
                        }
                        if (a.score > b.score) {
                            return -1;
                        }
                    }
                    return b.member.compareTo(a.member);
                }
            };
        }
    }
}

