/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rarefiedredis.redis.AbstractRedisMock;
import org.rarefiedredis.redis.ArgException;
import org.rarefiedredis.redis.IRedis;
import org.rarefiedredis.redis.IRedisClient;
import org.rarefiedredis.redis.NotFloatHashException;
import org.rarefiedredis.redis.NotImplementedException;
import org.rarefiedredis.redis.NotIntegerHashException;
import org.rarefiedredis.redis.ScanResult;
import org.rarefiedredis.redis.WrongTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RedisMockMulti
extends AbstractRedisMock {
    private IRedis redisMock;
    private List<MultiCommand> commands;

    public RedisMockMulti(IRedis redisMock) {
        this.redisMock = redisMock;
        this.commands = new ArrayList<MultiCommand>();
    }

    private synchronized Object command(String name, Object ... args) {
        ArrayList<Object> argList = new ArrayList<Object>();
        for (Object arg : args) {
            argList.add(arg);
        }
        this.commands.add(new MultiCommand(name, argList));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Object> exec() {
        ArrayList<Object> returns = new ArrayList<Object>(this.commands.size());
        Method[] methods = this.redisMock.getClass().getDeclaredMethods();
        IRedis iRedis = this.redisMock;
        synchronized (iRedis) {
            for (MultiCommand command : this.commands) {
                if (!this.modified(this.redisMock.hashCode(), command.command, command.args)) continue;
                try {
                    this.redisMock.unwatch();
                }
                catch (NotImplementedException nie) {
                    // empty catch block
                }
                return null;
            }
            for (MultiCommand command : this.commands) {
                Class[] parameterTypes = new Class[command.args.size()];
                for (int idx = 0; idx < parameterTypes.length; ++idx) {
                    parameterTypes[idx] = command.args.get(idx).getClass();
                }
                try {
                    Object ret = this.redisMock.getClass().getDeclaredMethod(command.command, parameterTypes).invoke((Object)this.redisMock, command.args.toArray());
                    returns.add(ret);
                }
                catch (Exception e) {
                    returns.add(e);
                }
            }
            try {
                this.redisMock.unwatch();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return returns;
    }

    @Override
    public IRedisClient multi() {
        return new RedisMockMulti(this.redisMock);
    }

    @Override
    public synchronized String discard() throws NotImplementedException {
        this.commands.clear();
        return this.redisMock.unwatch();
    }

    @Override
    public String unwatch() throws NotImplementedException {
        return this.redisMock.unwatch();
    }

    @Override
    public String watch(String key) throws NotImplementedException {
        return this.redisMock.watch(key);
    }

    @Override
    public IRedisClient createClient() {
        return this.redisMock.createClient();
    }

    @Override
    public boolean modified(Integer hashCode, String command, List<Object> args) {
        return this.redisMock.modified(hashCode, command, args);
    }

    @Override
    public Long del(String ... keys) {
        return (Long)this.command("del", new Object[]{keys});
    }

    @Override
    public Boolean exists(String key) {
        return (Boolean)this.command("exists", key);
    }

    @Override
    public Boolean expire(String key, int seconds) {
        return (Boolean)this.command("expire", key, seconds);
    }

    @Override
    public Boolean expireat(String key, long timestamp) {
        return (Boolean)this.command("expireat", key, timestamp);
    }

    @Override
    public Boolean persist(String key) {
        return (Boolean)this.command("persist", key);
    }

    @Override
    public Boolean pexpire(String key, long milliseconds) {
        return (Boolean)this.command("pexpire", key, milliseconds);
    }

    @Override
    public Boolean pexpireat(String key, long timestamp) {
        return (Boolean)this.command("pexpireat", key, timestamp);
    }

    @Override
    public String type(String key) {
        return (String)this.command("type", key);
    }

    @Override
    public Long append(String key, String value) {
        return (Long)this.command("append", key, value);
    }

    @Override
    public Long bitcount(String key, long ... options) {
        return (Long)this.command("bitcount", key, options);
    }

    @Override
    public Long bitop(String operation, String destkey, String ... keys) {
        return (Long)this.command("bitop", operation, destkey, keys);
    }

    @Override
    public Long bitpos(String key, long bit, long ... options) {
        return (Long)this.command("bitpos", key, bit, options);
    }

    @Override
    public Long decr(String key) {
        return (Long)this.command("decr", key);
    }

    @Override
    public Long decrby(String key, long decrement) {
        return (Long)this.command("decrby", key, decrement);
    }

    @Override
    public String get(String key) {
        return (String)this.command("get", key);
    }

    @Override
    public Boolean getbit(String key, long offset) {
        return (Boolean)this.command("getbit", key, offset);
    }

    @Override
    public String getrange(String key, long start, long end) {
        return (String)this.command("getrange", key, start, end);
    }

    @Override
    public String getset(String key, String value) {
        return (String)this.command("getset", key, value);
    }

    @Override
    public Long incr(String key) {
        return (Long)this.command("incr", key);
    }

    @Override
    public Long incrby(String key, long increment) {
        return (Long)this.command("incrby", key, increment);
    }

    @Override
    public String incrbyfloat(String key, double increment) {
        return (String)this.command("incrbyfloat", key, increment);
    }

    @Override
    public String[] mget(String ... keys) {
        return (String[])this.command("mget", keys);
    }

    @Override
    public String mset(String ... keyvalues) {
        return (String)this.command("mset", new Object[]{keyvalues});
    }

    @Override
    public Boolean msetnx(String ... keyvalues) {
        return (Boolean)this.command("msetnx", new Object[]{keyvalues});
    }

    @Override
    public String psetex(String key, long milliseconds, String value) {
        return (String)this.command("psetex", key, milliseconds, value);
    }

    @Override
    public String set(String key, String value, String ... options) {
        return (String)this.command("set", key, value, options);
    }

    @Override
    public Long setbit(String key, long offset, boolean value) {
        return (Long)this.command("setbit", key, offset, value);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return (String)this.command("setex", key, seconds, value);
    }

    @Override
    public Long setnx(String key, String value) {
        return (Long)this.command("setnx", key, value);
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        return (Long)this.command("setrange", key, offset, value);
    }

    @Override
    public Long strlen(String key) {
        return (Long)this.command("strlen", key);
    }

    @Override
    public String lindex(String key, long index) {
        return (String)this.command("lindex", key, index);
    }

    @Override
    public Long linsert(String key, String before_after, String pivot, String value) {
        return (Long)this.command("linsert", key, before_after, pivot, value);
    }

    @Override
    public Long llen(String key) {
        return (Long)this.command("llen", key);
    }

    @Override
    public String lpop(String key) {
        return (String)this.command("lpop", key);
    }

    @Override
    public Long lpush(String key, String element, String ... elements) {
        return (Long)this.command("lpush", key, element, elements);
    }

    @Override
    public Long lpushx(String key, String element) {
        return (Long)this.command("lpushx", key, element);
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        return (List)this.command("lrange", key, start, end);
    }

    @Override
    public Long lrem(String key, long count, String element) {
        return (Long)this.command("lrem", key, count, element);
    }

    @Override
    public String lset(String key, long index, String element) {
        return (String)this.command("lset", key, index, element);
    }

    @Override
    public String ltrim(String key, long start, long end) {
        return (String)this.command("ltrim", key, start, end);
    }

    @Override
    public String rpop(String key) {
        return (String)this.command("rpop", key);
    }

    @Override
    public String rpoplpush(String source, String dest) {
        return (String)this.command("rpoplpush", source, dest);
    }

    @Override
    public Long rpush(String key, String element, String ... elements) {
        return (Long)this.command("rpush", key, element, elements);
    }

    @Override
    public Long rpushx(String key, String element) {
        return (Long)this.command("rpushx", key, element);
    }

    @Override
    public Long sadd(String key, String member, String ... members) {
        return (Long)this.command("sadd", key, member, members);
    }

    @Override
    public Long scard(String key) {
        return (Long)this.command("scard", key);
    }

    @Override
    public Set<String> sdiff(String key, String ... keys) {
        return (Set)this.command("sdiff", key, keys);
    }

    @Override
    public Long sdiffstore(String destination, String key, String ... keys) {
        return (Long)this.command("sdiffstore", destination, key, keys);
    }

    @Override
    public Set<String> sinter(String key, String ... keys) {
        return (Set)this.command("sinter", key, keys);
    }

    @Override
    public Long sinterstore(String destination, String key, String ... keys) {
        return (Long)this.command("sinterstore", destination, key, keys);
    }

    @Override
    public Boolean sismember(String key, String member) {
        return (Boolean)this.command("sismember", key, member);
    }

    @Override
    public Set<String> smembers(String key) {
        return (Set)this.command("smembers", key);
    }

    @Override
    public Boolean smove(String source, String dest, String member) {
        return (Boolean)this.command("smove", source, dest, member);
    }

    @Override
    public String spop(String key) {
        return (String)this.command("spop", key);
    }

    @Override
    public String srandmember(String key) {
        return (String)this.command("srandmember", key);
    }

    @Override
    public List<String> srandmember(String key, long count) {
        return (List)this.command("srandmember", key, count);
    }

    @Override
    public Long srem(String key, String member, String ... members) {
        return (Long)this.command("srem", key, member, members);
    }

    @Override
    public Set<String> sunion(String key, String ... keys) {
        return (Set)this.command("sunion", key, keys);
    }

    @Override
    public Long sunionstore(String destination, String key, String ... keys) {
        return (Long)this.command("sunionstore", destination, key, keys);
    }

    @Override
    public ScanResult<Set<String>> sscan(String key, long cursor, String ... options) {
        return (ScanResult)this.command("sscan", key, cursor, options);
    }

    @Override
    public Long hdel(String key, String field, String ... fields) {
        return (Long)this.command("hdel", key, field, fields);
    }

    @Override
    public Boolean hexists(String key, String field) {
        return (Boolean)this.command("hexists", key, field);
    }

    @Override
    public String hget(String key, String field) {
        return (String)this.command("hget", key, field);
    }

    @Override
    public Map<String, String> hgetall(String key) {
        return (Map)this.command("hgetall", key);
    }

    @Override
    public Long hincrby(String key, String field, long increment) throws WrongTypeException, NotIntegerHashException {
        return (Long)this.command("hincrby", key, field, increment);
    }

    @Override
    public String hincrbyfloat(String key, String field, double increment) throws WrongTypeException, NotFloatHashException {
        return (String)this.command("hincrbyfloat", key, field, increment);
    }

    @Override
    public Set<String> hkeys(String key) throws WrongTypeException {
        return (Set)this.command("hkeys", key);
    }

    @Override
    public Long hlen(String key) throws WrongTypeException {
        return (Long)this.command("hlen", key);
    }

    @Override
    public List<String> hmget(String key, String field, String ... fields) throws WrongTypeException {
        return (List)this.command("hmget", key, field, fields);
    }

    @Override
    public String hmset(String key, String field, String value, String ... fieldsvalues) throws WrongTypeException, ArgException {
        return (String)this.command("hmset", key, field, value, fieldsvalues);
    }

    @Override
    public Boolean hset(String key, String field, String value) throws WrongTypeException {
        return (Boolean)this.command("hset", key, field, value);
    }

    @Override
    public Boolean hsetnx(String key, String field, String value) throws WrongTypeException {
        return (Boolean)this.command("hsetnx", key, field, value);
    }

    @Override
    public Long hstrlen(String key, String field) throws WrongTypeException {
        return (Long)this.command("hstrlen", key, field);
    }

    @Override
    public List<String> hvals(String key) throws WrongTypeException {
        return (List)this.command("hvals", key);
    }

    @Override
    public ScanResult<Map<String, String>> hscan(String key, long cursor, String ... options) {
        return (ScanResult)this.command("hscan", key, cursor, options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MultiCommand {
        public String command;
        public List<Object> args;

        public MultiCommand(String command, List<Object> args) {
            this.command = command;
            this.args = args;
        }
    }
}

