/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.rarefiedredis.redis.IRedisCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RedisSortedSetCache
implements IRedisCache<String, Set<String>> {
    private Map<String, SortedSet<String>> cache = new HashMap<String, SortedSet<String>>();
    private Map<String, Map<String, Double>> scores = new HashMap<String, Map<String, Double>>();

    @Override
    public Boolean exists(String key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void remove(String key) {
        this.cache.remove(key);
        this.scores.remove(key);
    }

    @Override
    public void set(final String key, String value, Object ... arguments) {
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String a, String b) {
                    Double aScore = (Double)((Map)RedisSortedSetCache.this.scores.get(key)).get(a);
                    Double bScore = (Double)((Map)RedisSortedSetCache.this.scores.get(key)).get(b);
                    if (aScore < bScore) {
                        return -1;
                    }
                    if (aScore > bScore) {
                        return 1;
                    }
                    return a.compareTo(b);
                }
            }));
            this.scores.put(key, new HashMap());
        }
        Double score = (Double)arguments[0];
        this.cache.get(key).add(value);
        this.scores.get(key).put(value, score);
    }

    @Override
    public Set<String> get(String key) {
        return this.cache.get(key);
    }

    public Double getScore(String key, String value) {
        if (!this.scores.containsKey(key)) {
            return null;
        }
        return this.scores.get(key).get(value);
    }

    @Override
    public Boolean removeValue(String key, String value) {
        if (!this.cache.containsKey(key)) {
            return false;
        }
        this.scores.get(key).remove(value);
        return this.cache.get(key).remove(value);
    }

    @Override
    public String type() {
        return "set";
    }
}

