/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis.adapter.jedis;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rarefiedredis.redis.AbstractRedisClient;
import org.rarefiedredis.redis.ArgException;
import org.rarefiedredis.redis.IRedisClient;
import org.rarefiedredis.redis.IRedisSortedSet;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JedisIRedisClientMulti
extends AbstractRedisClient {
    private Transaction transaction;
    private Response lastResponse;

    public JedisIRedisClientMulti(Jedis jedis) {
        this.transaction = jedis.multi();
    }

    private Object command(String name, Object ... args) {
        try {
            this.lastResponse = (Response)this.transaction.getClass().getDeclaredMethod(name, new Class[0]).invoke((Object)this.transaction, args);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            return null;
        }
        return null;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public Long del(String ... keys) {
        return (Long)this.command("del", new Object[]{keys});
    }

    @Override
    public String dump(String key) {
        return (String)this.command("dump", key);
    }

    @Override
    public Boolean exists(String key) {
        return (Boolean)this.command("exists", key);
    }

    @Override
    public Boolean expireat(String key, long timestamp) {
        return (Long)this.command("expireat", key, timestamp) == 1L;
    }

    @Override
    public Long move(String key, int db) {
        return (Long)this.command("move", key, db);
    }

    @Override
    public Boolean persist(String key) {
        return (Long)this.command("persist", key) == 1L;
    }

    @Override
    public Boolean pexpireat(String key, long timestamp) {
        return (Long)this.command("pexpireat", key, timestamp) == 1L;
    }

    @Override
    public Long pttl(String key) {
        return (Long)this.command("pttl", key);
    }

    @Override
    public String randomkey() {
        return (String)this.command("randomkey", new Object[0]);
    }

    @Override
    public String rename(String key, String newkey) {
        return (String)this.command("rename", key, newkey);
    }

    @Override
    public Boolean renamenx(String key, String newkey) {
        return (Long)this.command("renamenx", key, newkey) == 1L;
    }

    @Override
    public String restore(String key, int ttl, String serialized_value) {
        return (String)this.command("restore", key, ttl, serialized_value.getBytes());
    }

    @Override
    public Long ttl(String key) {
        return (Long)this.command("ttl", key);
    }

    @Override
    public String type(String key) {
        return (String)this.command("type", key);
    }

    @Override
    public Long append(String key, String value) {
        return (Long)this.command("append", key, value);
    }

    @Override
    public Long bitcount(String key, long ... options) {
        if (options.length == 2) {
            return (Long)this.command("bitcount", key, options[0], options[1]);
        }
        return (Long)this.command("bitcount", key);
    }

    @Override
    public Long bitop(String operation, String destkey, String ... keys) {
        BitOP op = BitOP.valueOf((String)operation);
        return (Long)this.command("bitop", op, destkey, keys);
    }

    @Override
    public Long decr(String key) {
        return (Long)this.command("decr", key);
    }

    @Override
    public Long decrby(String key, long decrement) {
        return (Long)this.command("decrBy", key, decrement);
    }

    @Override
    public String get(String key) {
        return (String)this.command("get", key);
    }

    @Override
    public Boolean getbit(String key, long offset) {
        return (Boolean)this.command("getbit", key, offset);
    }

    @Override
    public String getrange(String key, long start, long end) {
        return (String)this.command("getrange", key, start, end);
    }

    @Override
    public String getset(String key, String value) {
        return (String)this.command("getSet", key, value);
    }

    @Override
    public Long incr(String key) {
        return (Long)this.command("incr", key);
    }

    @Override
    public Long incrby(String key, long increment) {
        return (Long)this.command("incrBy", key, increment);
    }

    @Override
    public String incrbyfloat(String key, double increment) {
        return String.valueOf((Double)this.command("incrByFloat", key, increment));
    }

    @Override
    public String mset(String ... keysvalues) {
        return (String)this.command("mset", new Object[]{keysvalues});
    }

    @Override
    public Boolean msetnx(String ... keysvalues) {
        return (Long)this.command("msetnx", keysvalues) == 1L;
    }

    @Override
    public String psetex(String key, long milliseconds, String value) {
        return (String)this.command("psetex", key, milliseconds, value);
    }

    @Override
    public String set(String key, String value, String ... options) {
        if (options.length == 0) {
            return (String)this.command("set", key, value);
        }
        String nxxx = null;
        String expx = null;
        long time = -1L;
        for (int idx = 0; idx < options.length; ++idx) {
            if (options[idx] == "nx") {
                nxxx = "nx";
                continue;
            }
            if (options[idx] == "xx") {
                nxxx = "xx";
                continue;
            }
            if (options[idx] == "ex") {
                expx = "ex";
                time = Long.valueOf(options[idx + 1]);
                continue;
            }
            if (options[idx] != "px") continue;
            expx = "px";
            time = Long.valueOf(options[idx + 1]);
        }
        if (nxxx != null && expx == null) {
            return (String)this.command("set", key, value, nxxx);
        }
        return (String)this.command("set", key, value, nxxx, expx, time);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return (String)this.command("setex", key, seconds, value);
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        return (Long)this.command("setrange", key, offset, value);
    }

    @Override
    public Long strlen(String key) {
        return (Long)this.command("strlen", key);
    }

    @Override
    public String lindex(String key, long index) {
        return (String)this.command("lindex", key, index);
    }

    @Override
    public Long linsert(String key, String before_after, String pivot, String value) {
        return (Long)this.command("linsert", key, BinaryClient.LIST_POSITION.valueOf((String)before_after), pivot, value);
    }

    @Override
    public Long llen(String key) {
        return (Long)this.command("llen", key);
    }

    @Override
    public String lpop(String key) {
        return (String)this.command("lpop", key);
    }

    @Override
    public Long lpush(String key, String element, String ... elements) {
        String[] strings = new String[1 + elements.length];
        strings[0] = element;
        for (int idx = 0; idx < elements.length; ++idx) {
            strings[idx + 1] = elements[idx];
        }
        return (Long)this.command("lpush", key, strings);
    }

    @Override
    public Long lpushx(String key, String element) {
        return (Long)this.command("lpushx", key, element);
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        return (List)this.command("lrange", key, start, end);
    }

    @Override
    public Long lrem(String key, long count, String element) {
        return (Long)this.command("lrem", key, count, element);
    }

    @Override
    public String lset(String key, long index, String element) {
        return (String)this.command("lset", key, index, element);
    }

    @Override
    public String ltrim(String key, long start, long end) {
        return (String)this.command("ltrim", key, start, end);
    }

    @Override
    public String rpop(String key) {
        return (String)this.command("rpop", key);
    }

    @Override
    public String rpoplpush(String source, String dest) {
        return (String)this.command("rpoplpush", source, dest);
    }

    @Override
    public Long rpush(String key, String element, String ... elements) {
        String[] strings = new String[1 + elements.length];
        strings[0] = element;
        for (int idx = 0; idx < elements.length; ++idx) {
            strings[idx + 1] = elements[idx];
        }
        return (Long)this.command("rpush", key, elements);
    }

    @Override
    public Long rpushx(String key, String element) {
        return (Long)this.command("rpushx", key, element);
    }

    @Override
    public Long sadd(String key, String member, String ... members) {
        String[] ms = new String[1 + members.length];
        ms[0] = member;
        for (int idx = 0; idx < members.length; ++idx) {
            ms[idx + 1] = members[idx];
        }
        return (Long)this.command("sadd", key, ms);
    }

    @Override
    public Long scard(String key) {
        return (Long)this.command("scard", key);
    }

    @Override
    public Set<String> sdiff(String key, String ... keys) {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        return (Set)this.command("sdiff", new Object[]{ks});
    }

    @Override
    public Long sdiffstore(String destination, String key, String ... keys) {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        return (Long)this.command("sdiffstore", destination, ks);
    }

    @Override
    public Set<String> sinter(String key, String ... keys) {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        return (Set)this.command("sinter", new Object[]{ks});
    }

    @Override
    public Long sinterstore(String destination, String key, String ... keys) {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        return (Long)this.command("sinterstore", destination, ks);
    }

    @Override
    public Boolean sismember(String key, String member) {
        return (Boolean)this.command("sismember", key, member);
    }

    @Override
    public Set<String> smembers(String key) {
        return (Set)this.command("smembers", key);
    }

    @Override
    public Boolean smove(String source, String dest, String member) {
        return (Long)this.command("smove", source, dest, member) == 1L;
    }

    @Override
    public String spop(String key) {
        return (String)this.command("spop", key);
    }

    @Override
    public String srandmember(String key) {
        return (String)this.command("srandmember", key);
    }

    @Override
    public List<String> srandmember(String key, long count) {
        return (List)this.command("srandmember", key, (int)count);
    }

    @Override
    public Long srem(String key, String member, String ... members) {
        String[] ms = new String[1 + members.length];
        ms[0] = member;
        for (int idx = 0; idx < members.length; ++idx) {
            ms[idx + 1] = members[idx];
        }
        return (Long)this.command("srem", key, ms);
    }

    @Override
    public Set<String> sunion(String key, String ... keys) {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        return (Set)this.command("sunion", new Object[]{ks});
    }

    @Override
    public Long sunionstore(String destination, String key, String ... keys) {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        return (Long)this.command("sunionstore", destination, ks);
    }

    @Override
    public Long hdel(String key, String field, String ... fields) {
        String[] fs = new String[1 + fields.length];
        fs[0] = field;
        for (int idx = 0; idx < fields.length; ++idx) {
            fs[idx + 1] = fields[idx];
        }
        return (Long)this.command("hdel", key, fs);
    }

    @Override
    public Boolean hexists(String key, String field) {
        return (Boolean)this.command("hexists", key, field);
    }

    @Override
    public String hget(String key, String field) {
        return (String)this.command("hget", key, field);
    }

    @Override
    public Map<String, String> hgetall(String key) {
        return (Map)this.command("hgetAll", key);
    }

    @Override
    public Long hincrby(String key, String field, long increment) {
        return (Long)this.command("hincrBy", key, field, increment);
    }

    @Override
    public String hincrbyfloat(String key, String field, double increment) {
        return String.valueOf((Double)this.command("hincrByFloat", key, field, increment));
    }

    @Override
    public Set<String> hkeys(String key) {
        return (Set)this.command("hkeys", key);
    }

    @Override
    public Long hlen(String key) {
        return (Long)this.command("hlen", key);
    }

    @Override
    public List<String> hmget(String key, String field, String ... fields) {
        String[] fs = new String[1 + fields.length];
        fs[0] = field;
        for (int idx = 0; idx < fields.length; ++idx) {
            fs[idx + 1] = fields[idx];
        }
        return (List)this.command("hmget", key, fs);
    }

    @Override
    public String hmset(String key, String field, String value, String ... fieldsvalues) throws ArgException {
        if (fieldsvalues.length % 2 != 0) {
            throw new ArgException("HMSET");
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put(field, value);
        for (int idx = 0; idx < fieldsvalues.length; ++idx) {
            if (idx % 2 != 0) continue;
            hash.put(fieldsvalues[idx], fieldsvalues[idx + 1]);
        }
        return (String)this.command("hmset", key, hash);
    }

    @Override
    public Boolean hset(String key, String field, String value) {
        return (Long)this.command("hset", key, field, value) == 1L;
    }

    @Override
    public Boolean hsetnx(String key, String field, String value) {
        return (Long)this.command("hsetnx", key, field, value) == 1L;
    }

    @Override
    public Long hstrlen(String key, String field) {
        return (Long)this.command("hstrlen", key, field);
    }

    @Override
    public List<String> hvals(String key) {
        return (List)this.command("hvals", key);
    }

    @Override
    public String discard() {
        return this.transaction.discard();
    }

    @Override
    public List<Object> exec() {
        return this.transaction.exec();
    }

    @Override
    public IRedisClient multi() {
        return this;
    }

    @Override
    public Long zadd(String key, IRedisSortedSet.ZsetPair scoremember, IRedisSortedSet.ZsetPair ... scoresmembers) {
        if (scoresmembers.length == 0) {
            return (Long)this.command("zadd", key, scoremember.score, scoremember.member);
        }
        HashMap<String, Double> sms = new HashMap<String, Double>();
        sms.put(scoremember.member, scoremember.score);
        for (IRedisSortedSet.ZsetPair pair : scoresmembers) {
            sms.put(pair.member, pair.score);
        }
        return (Long)this.command("zadd", key, sms);
    }

    @Override
    public Long zcard(String key) {
        return (Long)this.command("zcard", key);
    }

    @Override
    public Long zcount(String key, double min, double max) {
        return (Long)this.command("zcount", key, min, max);
    }

    @Override
    public String zincrby(String key, double increment, String member) {
        return String.valueOf((Double)this.command("zincrby", key, increment, member));
    }

    @Override
    public Long zlexcount(String key, String min, String max) {
        return (Long)this.command("zlexcount", key, min, max);
    }

    @Override
    public Long zrank(String key, String member) {
        return (Long)this.command("zrank", key, member);
    }

    @Override
    public Long zrem(String key, String member, String ... members) {
        String[] ms = new String[1 + members.length];
        ms[0] = member;
        for (int idx = 0; idx < members.length; ++idx) {
            ms[idx + 1] = members[idx];
        }
        return (Long)this.command("zrem", key, ms);
    }

    @Override
    public Long zremrangebylex(String key, String min, String max) {
        return (Long)this.command("zremrangebylex", key, min, max);
    }

    @Override
    public Long zremrangebyrank(String key, long start, long stop) {
        return (Long)this.command("zremrangebyrank", key, start, stop);
    }

    @Override
    public Long zremrangebyscore(String key, String min, String max) {
        return (Long)this.command("zremrangebyscore", key, min, max);
    }

    @Override
    public Long zrevrank(String key, String member) {
        return (Long)this.command("zrevrank", key, member);
    }

    @Override
    public Double zscore(String key, String member) {
        return (Double)this.command("zscore", key, member);
    }
}

