/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.IOException;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.CommonsArchiver;
import org.rauschig.jarchivelib.CommonsCompressor;
import org.rauschig.jarchivelib.IOUtils;

class ArchiverCompressorDecorator
implements Archiver {
    private CommonsArchiver archiver;
    private CommonsCompressor compressor;

    ArchiverCompressorDecorator(CommonsArchiver archiver, CommonsCompressor compressor) {
        this.archiver = archiver;
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File create(String archive, File destination, File ... sources) throws IOException {
        IOUtils.requireDirectory(destination);
        File temp = File.createTempFile(destination.getName(), this.archiver.getFileExtension(), destination);
        File destinationArchive = null;
        try {
            temp = this.archiver.create(temp.getName(), temp.getParentFile(), sources);
            destinationArchive = new File(destination, this.getArchiveFileName(archive));
            this.compressor.compress(temp, destinationArchive);
        }
        finally {
            temp.delete();
        }
        return destinationArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(File archive, File destination) throws IOException {
        IOUtils.requireDirectory(destination);
        File temp = File.createTempFile(archive.getName(), this.archiver.getFileExtension(), destination);
        try {
            this.compressor.decompress(archive, temp);
            this.archiver.extract(temp, destination);
        }
        finally {
            temp.delete();
        }
    }

    private String getArchiveFileName(String archive) {
        String fileExtension = this.archiver.getFileExtension() + this.compressor.getFileExtension();
        if (archive.endsWith(fileExtension)) {
            return archive;
        }
        if (archive.endsWith(this.archiver.getFileExtension())) {
            return archive + this.compressor.getFileExtension();
        }
        return archive + fileExtension;
    }
}

