/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverCompressorDecorator;
import org.rauschig.jarchivelib.CommonsArchiver;
import org.rauschig.jarchivelib.CommonsCompressor;
import org.rauschig.jarchivelib.CompressionType;
import org.rauschig.jarchivelib.FileType;
import org.rauschig.jarchivelib.FileTypeMap;

public final class ArchiverFactory {
    private ArchiverFactory() {
    }

    public static Archiver createArchiver(File archive) throws IllegalArgumentException {
        FileType extension = FileTypeMap.get(archive);
        if (extension == null) {
            throw new IllegalArgumentException("Unknown file extension " + archive.getName());
        }
        if (extension.isArchive() && extension.isCompressed()) {
            return ArchiverFactory.createArchiver(extension.getArchiveFormat(), extension.getCompression());
        }
        if (extension.isArchive()) {
            return ArchiverFactory.createArchiver(extension.getArchiveFormat());
        }
        throw new IllegalArgumentException("Unknown archive file extension " + archive.getName());
    }

    public static Archiver createArchiver(String archiveFormat, String compression) throws IllegalArgumentException {
        if (!ArchiveFormat.isValidArchiveFormat(archiveFormat)) {
            throw new IllegalArgumentException("Unknown archive format " + archiveFormat);
        }
        if (!CompressionType.isValidCompressionType(compression)) {
            throw new IllegalArgumentException("Unknown compression type " + compression);
        }
        CommonsArchiver archiver = new CommonsArchiver(archiveFormat);
        CommonsCompressor compressor = new CommonsCompressor(compression);
        return new ArchiverCompressorDecorator(archiver, compressor);
    }

    public static Archiver createArchiver(ArchiveFormat archiveFormat, CompressionType compression) {
        return ArchiverFactory.createArchiver(archiveFormat.getName(), compression.getName());
    }

    public static Archiver createArchiver(String archiveFormat) throws IllegalArgumentException {
        if (!ArchiveFormat.isValidArchiveFormat(archiveFormat)) {
            throw new IllegalArgumentException("Unknown archive format " + archiveFormat);
        }
        return new CommonsArchiver(archiveFormat);
    }

    public static Archiver createArchiver(ArchiveFormat archiveFormat) {
        return new CommonsArchiver(archiveFormat.getName());
    }
}

