/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.IOUtils;

class CommonsArchiver
implements Archiver {
    private ArchiveStreamFactory streamFactory = new ArchiveStreamFactory();
    private final String archiverName;
    private final String fileExtension;

    CommonsArchiver(String archiverName) {
        this.archiverName = archiverName.toLowerCase();
        this.fileExtension = "." + archiverName.toLowerCase();
    }

    public String getArchiverName() {
        return this.archiverName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public File create(String archive, File destination, File ... sources) throws IOException {
        IOUtils.requireDirectory(destination);
        File archiveFile = this.createNewArchiveFile(archive, this.fileExtension, destination);
        try (ArchiveOutputStream outputStream = this.createArchiveOutputStream(archiveFile);){
            this.writeToArchive(sources, outputStream);
            outputStream.flush();
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
        return archiveFile;
    }

    @Override
    public void extract(File archive, File destination) throws IOException {
        if (archive.isDirectory()) {
            throw new IllegalArgumentException("Can not extract " + archive + ". Source is a directory.");
        }
        if (!archive.exists()) {
            throw new FileNotFoundException(archive.getPath());
        }
        if (!archive.canRead()) {
            throw new IllegalArgumentException("Can not extract " + archive + ". Can not read from source.");
        }
        IOUtils.requireDirectory(destination);
        try (ArchiveInputStream input = this.createArchiveInputStream(archive);){
            ArchiveEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                File file = new File(destination, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                IOUtils.copy((InputStream)input, file);
            }
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    protected ArchiveOutputStream createArchiveOutputStream(File archive) throws IOException, ArchiveException {
        return this.streamFactory.createArchiveOutputStream(this.archiverName, new FileOutputStream(archive));
    }

    protected ArchiveInputStream createArchiveInputStream(File archive) throws IOException, ArchiveException {
        return this.streamFactory.createArchiveInputStream(new BufferedInputStream(new FileInputStream(archive)));
    }

    protected File createNewArchiveFile(String archive, String extension, File destination) throws IOException {
        if (!archive.endsWith(extension)) {
            archive = archive + extension;
        }
        File file = new File(destination, archive);
        file.createNewFile();
        return file;
    }

    protected void writeToArchive(File[] sources, ArchiveOutputStream archive) throws IOException {
        for (File source : sources) {
            if (!source.exists()) {
                throw new FileNotFoundException(source.getPath());
            }
            if (!source.canRead()) {
                throw new FileNotFoundException(source.getPath() + " (Permission denied)");
            }
            if (source.isFile()) {
                this.writeToArchive(source.getParentFile(), new File[]{source}, archive);
                continue;
            }
            this.writeToArchive(source, source.listFiles(), archive);
        }
    }

    protected void writeToArchive(File parent, File[] sources, ArchiveOutputStream archive) throws IOException {
        for (File source : sources) {
            String relativePath = IOUtils.relativePath(parent, source);
            this.createArchiveEntry(source, relativePath, archive);
            if (!source.isDirectory()) continue;
            this.writeToArchive(parent, source.listFiles(), archive);
        }
    }

    protected void createArchiveEntry(File file, String entryName, ArchiveOutputStream archive) throws IOException {
        ArchiveEntry entry = archive.createArchiveEntry(file, entryName);
        archive.putArchiveEntry(entry);
        if (!entry.isDirectory()) {
            try (FileInputStream input = new FileInputStream(file);){
                IOUtils.copy((InputStream)input, archive);
            }
        }
        archive.closeArchiveEntry();
    }
}

