/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.rauschig.jarchivelib.Compressor;

class CommonsCompressor
implements Compressor {
    private CompressorStreamFactory streamFactory = new CompressorStreamFactory();
    private final String compressorName;
    private final String fileExtension;

    CommonsCompressor(String compressorName) {
        this.compressorName = compressorName.toLowerCase();
        this.fileExtension = "." + compressorName.toLowerCase();
    }

    public String getCompressorName() {
        return this.compressorName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public void compress(File source, File destination) throws IllegalArgumentException, IOException {
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Can not compress " + source + ". Source is a directory.");
        }
        if (!source.exists()) {
            throw new FileNotFoundException(source.getPath());
        }
        if (!source.canRead()) {
            throw new IllegalArgumentException("Can not compress " + source + ". Can not read from source.");
        }
        if (destination.isDirectory()) {
            throw new IllegalArgumentException("Can not compress into " + destination + ". Destination is a directory.");
        }
        try (CompressorOutputStream compressed = this.createCompressorOutputStream(destination);
             BufferedInputStream input = new BufferedInputStream(new FileInputStream(source));){
            IOUtils.copy(input, compressed);
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void decompress(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Can not decompress " + source + ". Source is a directory.");
        }
        if (!source.exists()) {
            throw new FileNotFoundException(source.getName());
        }
        if (!source.canRead()) {
            throw new IllegalArgumentException("Can not decompress " + source + ". Can not read from source.");
        }
        if (destination.isDirectory()) {
            throw new IllegalArgumentException("Can not decompress into " + destination + ". Destination is a directory.");
        }
        try (CompressorInputStream compressed = this.createCompressorInputStream(source);
             FileOutputStream output = new FileOutputStream(destination);){
            IOUtils.copy(compressed, output);
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
    }

    protected CompressorOutputStream createCompressorOutputStream(File destination) throws IOException, CompressorException {
        return this.streamFactory.createCompressorOutputStream(this.compressorName, new FileOutputStream(destination));
    }

    protected CompressorInputStream createCompressorInputStream(File source) throws IOException, CompressorException {
        return this.streamFactory.createCompressorInputStream(new BufferedInputStream(new FileInputStream(source)));
    }
}

