/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import org.rauschig.jarchivelib.CommonsCompressor;
import org.rauschig.jarchivelib.CompressionType;
import org.rauschig.jarchivelib.Compressor;
import org.rauschig.jarchivelib.FileType;
import org.rauschig.jarchivelib.FileTypeMap;

public final class CompressorFactory {
    private CompressorFactory() {
    }

    public static Compressor createCompressor(File file) throws IllegalArgumentException {
        FileType extension = FileTypeMap.get(file);
        if (extension == null) {
            throw new IllegalArgumentException("Unknown file extension " + file.getName());
        }
        if (extension.isCompressed()) {
            return CompressorFactory.createCompressor(extension.getCompression());
        }
        throw new IllegalArgumentException("Unknown compressed file extension " + file.getName());
    }

    public static Compressor createCompressor(String compression) throws IllegalArgumentException {
        if (!CompressionType.isValidCompressionType(compression)) {
            throw new IllegalArgumentException("Unkonwn compression type " + compression);
        }
        return new CommonsCompressor(compression);
    }

    public static Compressor createCompressor(CompressionType compression) {
        return new CommonsCompressor(compression.getName());
    }
}

