/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.CompressionType;
import org.rauschig.jarchivelib.FileType;

final class FileTypeMap {
    private static final Map<String, FileType> MAP = new LinkedHashMap<String, FileType>();

    private FileTypeMap() {
    }

    private static void add(String suffix, ArchiveFormat archiveFormat) {
        MAP.put(suffix, new FileType(suffix, archiveFormat));
    }

    private static void add(String suffix, CompressionType compressionType) {
        MAP.put(suffix, new FileType(suffix, compressionType));
    }

    private static void add(String suffix, ArchiveFormat archiveFormat, CompressionType compressionType) {
        MAP.put(suffix, new FileType(suffix, archiveFormat, compressionType));
    }

    public static FileType get(String filename) {
        for (String suffix : MAP.keySet()) {
            if (!filename.endsWith(suffix)) continue;
            return MAP.get(suffix);
        }
        return null;
    }

    public static FileType get(File file) {
        return FileTypeMap.get(file.getName());
    }

    static {
        FileTypeMap.add(".tar.gz", ArchiveFormat.TAR, CompressionType.GZIP);
        FileTypeMap.add(".tgz", ArchiveFormat.TAR, CompressionType.GZIP);
        FileTypeMap.add(".tar.bz2", ArchiveFormat.TAR, CompressionType.BZIP2);
        FileTypeMap.add(".tbz2", ArchiveFormat.TAR, CompressionType.BZIP2);
        FileTypeMap.add(".a", ArchiveFormat.AR);
        FileTypeMap.add(".ar", ArchiveFormat.AR);
        FileTypeMap.add(".cpio", ArchiveFormat.CPIO);
        FileTypeMap.add(".dump", ArchiveFormat.DUMP);
        FileTypeMap.add(".jar", ArchiveFormat.JAR);
        FileTypeMap.add(".tar", ArchiveFormat.TAR);
        FileTypeMap.add(".zip", ArchiveFormat.ZIP);
        FileTypeMap.add(".zipx", ArchiveFormat.ZIP);
        FileTypeMap.add(".bz2", CompressionType.BZIP2);
        FileTypeMap.add(".gzip", CompressionType.GZIP);
        FileTypeMap.add(".gz", CompressionType.GZIP);
        FileTypeMap.add(".pack", CompressionType.PACK200);
    }
}

