/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8024;

    private IOUtils() {
    }

    public static void copy(InputStream source, File destination) throws IOException {
        try (FileOutputStream output = new FileOutputStream(destination);){
            IOUtils.copy(source, output);
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 8024);
    }

    public static long copy(InputStream input, OutputStream output, int buffersize) throws IOException {
        int n;
        byte[] buffer = new byte[buffersize];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String relativePath(File root, File node) throws IOException {
        String rootPath = root.getCanonicalPath();
        String nodePath = node.getCanonicalPath();
        return nodePath.substring(rootPath.length() + 1);
    }

    public static void requireDirectory(File destination) throws IOException, IllegalArgumentException {
        if (destination.isFile()) {
            throw new IllegalArgumentException(destination + " exists and is a file, directory or path expected.");
        }
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if (!destination.canWrite()) {
            throw new IllegalArgumentException("Can not write to destination " + destination);
        }
    }

    public static String getContentType(File file) throws IOException {
        return Files.probeContentType(Paths.get(file.getPath(), new String[0]));
    }
}

