/*
 * Decompiled with CFR 0.152.
 */
package org.raystack.stencil;

import java.util.List;
import org.raystack.stencil.cache.SchemaCacheLoader;
import org.raystack.stencil.client.ClassLoadStencilClient;
import org.raystack.stencil.client.MultiURLStencilClient;
import org.raystack.stencil.client.StencilClient;
import org.raystack.stencil.client.URLStencilClient;
import org.raystack.stencil.config.StencilConfig;
import org.raystack.stencil.http.RemoteFileImpl;
import org.raystack.stencil.http.RetryHttpClient;

public class StencilClientFactory {
    public static StencilClient getClient(String url, StencilConfig config) {
        SchemaCacheLoader cacheLoader = new SchemaCacheLoader(new RemoteFileImpl(RetryHttpClient.create(config)), config);
        return new URLStencilClient(url, config, cacheLoader);
    }

    public static StencilClient getClient(List<String> urls, StencilConfig config) {
        SchemaCacheLoader cacheLoader = new SchemaCacheLoader(new RemoteFileImpl(RetryHttpClient.create(config)), config);
        return new MultiURLStencilClient(urls, config, cacheLoader);
    }

    public static StencilClient getClient() {
        return new ClassLoadStencilClient();
    }
}

